/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.CPUComparator;
import com.ibm.hsc.cim.provider.rs6k.CecUpdater;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.MemoryComparator;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.cim.provider.rs6k.OpPanelPoller;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import com.ibm.hsc.security.HscPermission;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class Activator {
    static final int REDUNDANT_ADAPTERNUM = 2;
    private ProviderCIMOMHandle _cimomHandle = null;
    private Vector _invalidLPARs = null;
    private byte[] _lparOpState = null;
    private byte[] _lparDefState = null;
    private byte _theLPAR;
    private CIMObjectPath _partitionOP;
    private byte _theLPAROpState;
    private byte _theLPARDefState;
    private String _profileTimeStamp;
    private HscProviderSocket _socket = null;
    private Hashtable _ioAssignment = null;
    private Hashtable _ioReassignment = null;
    private Hashtable _ioFree = null;
    private Hashtable _cpuAssignment = null;
    private Hashtable _cpuReassignment = null;
    private long _memoryAssigned = 0L;
    private long _maxMem = 0L;
    private boolean _updateCIMOM = false;
    private String _cecNameStr = null;
    private NVRAM _nvram;
    private Hashtable _ioSlotsToCheck = null;
    private Hashtable _cpusToCheck = null;
    private String _partitionName = null;
    private String _lparUserDefName = null;
    private String _cecUserDefName = null;
    private Vector _procSequence = null;
    private long _updatePollFreq = 500L;
    private long _maxUpdatePollTime = 60000L;
    private int _procIDForUpdateMemory = -1;
    private int _bootMode = 0;
    private Vector _smaDeviceIDs = null;
    private Vector _smaWindowSizes = null;
    private Vector _smaLPARIDs = null;
    private Vector _smaLPARDeviceIDs = null;
    private short _versionLparProfId;
    private short _versionLparProfUsrDefName;
    private short _versionLparProfDraInfo;
    private short _versionLparProfSlotInfo;
    private short _versionLparProfReqDes;
    private short _versionLparProfReqCpu;
    private short _versionLparProfDesCpu;
    private short _versionLparProfMaxCpu;
    private short _versionLparProfReqMem;
    private short _versionLparProfDesMem;
    private short _versionLparProfMaxMem;
    private short _versionLparProfSerAuth;
    private short _versionLparProfbooMod;
    private short _versionLparProfRMOSize;
    private short _versionLparProfSFPSur;
    private short _versionLparProfSMAMode;
    private short _versionLparProfSMADevID;
    private short _versionLparProfSMAWindows;
    private int _partitionType = 0;
    private int _partitionMode = 0;
    private String _partitionPhysicalLocCode = null;
    private String _partitionAffinityGroup = null;
    private Vector _cpusAllocateForPPAR = null;
    private boolean _isPhysicalPartition = false;
    private String _cspVersion = "";
    private int _cspMappedVer = -1;
    private int _cspCapability = 255;
    private int _cspRunTimeCap = 0;

    Activator(byte by, String string, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, CIMOMHandle cIMOMHandle) throws CIMException {
        new Activator(by, string, cIMObjectPath, hscProviderSocket, cIMOMHandle, 0);
    }

    Activator(byte by, String string, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, CIMOMHandle cIMOMHandle, boolean bl) throws CIMException {
        System.out.println("new Activator instance");
        System.out.println("partitionID = " + by);
        System.out.println("profileID = " + string);
        System.out.println("partitionPath = " + cIMObjectPath);
        System.out.println("socket = " + hscProviderSocket);
        Trace.trace("appahscT", "-> activator");
        Trace.trace("appahscF", "partitionID = " + String.valueOf(by));
        Trace.trace("appahscF", "profileID = " + string);
        Trace.trace("appahscF", "partitionPath = " + cIMObjectPath);
        Trace.trace("appahscF", "socket = " + hscProviderSocket);
        Trace.trace("appahscF", "handle = " + cIMOMHandle);
        this._theLPAR = by;
        this._profileTimeStamp = string;
        this._socket = hscProviderSocket;
        this._partitionOP = cIMObjectPath;
        this._cimomHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throw new HSCCIMException("1586", new String[]{cIMObjectPath.toString()});
        }
        Trace.trace("appahscF", "partitionInstance = " + cIMInstance);
        this._partitionName = (String)cIMInstance.getProperty("Name").getValue().getValue();
        this._lparUserDefName = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
        this._partitionType = ((UnsignedInt8)cIMInstance.getProperty("PartitionType").getValue().getValue()).intValue();
        if (this._partitionType == 3 || this._partitionType == 2) {
            this._isPhysicalPartition = true;
            this._partitionPhysicalLocCode = (String)cIMInstance.getProperty("PhysLocCode").getValue().getValue();
            this._partitionAffinityGroup = (String)cIMInstance.getProperty("AffinityGroupID").getValue().getValue();
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("_partitionName = " + this._partitionName);
            System.out.println("_lparUserDefName = " + this._lparUserDefName);
        }
        int n = this._partitionName.indexOf(42);
        this._cecNameStr = this._partitionName.substring(n + 1);
        Trace.trace("appahscD", "_cecNameStr = " + this._cecNameStr);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath2.addKey("Name", new CIMValue((Object)this._cecNameStr));
        CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath2, this._cimomHandle.getClass(cIMObjectPath2, false), false);
        this._cecUserDefName = (String)CimomWrapper.getProperty(cIMInstance2, "UserDefinedName");
        try {
            this._cspVersion = (String)CimomWrapper.getProperty(cIMInstance2, "CSPVersion");
            this._cspMappedVer = VersionComparator.CSPVersionValue(this._cspVersion);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        this._setIndexByVersion(this._cspMappedVer);
        this._updateCIMOM = false;
        Hashtable hashtable = null;
        hashtable = HscProviderUtils.getCapabilities(this._cspVersion, this._socket);
        int n2 = (Integer)hashtable.get("CecMode");
        this._cspCapability = ((Integer)hashtable.get("CecCapability")).shortValue();
        this._cspRunTimeCap = ((Integer)hashtable.get("RuntimeCapability")).shortValue();
        this._invalidLPARs = new Vector();
    }

    Activator(byte by, String string, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, CIMOMHandle cIMOMHandle, int n) throws CIMException {
        try {
            block72: {
                try {
                    Object object;
                    int n2;
                    String[] stringArray;
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("*****************************************");
                        System.out.println("In activate");
                        System.out.println("partitionID = " + by);
                        System.out.println("profileID = " + string);
                        System.out.println("partitionPath = " + cIMObjectPath);
                        System.out.println("socket = " + hscProviderSocket);
                        System.out.println("bootModeValue = " + n);
                    }
                    System.out.println("new Activator instance");
                    System.out.println("partitionID = " + by);
                    System.out.println("profileID = " + string);
                    System.out.println("partitionPath = " + cIMObjectPath);
                    System.out.println("socket = " + hscProviderSocket);
                    System.out.println("bootModeValue = " + n);
                    Trace.trace("appahscT", "-> activator");
                    Trace.trace("appahscF", "partitionID = " + String.valueOf(by));
                    Trace.trace("appahscF", "profileID = " + string);
                    Trace.trace("appahscF", "partitionPath = " + cIMObjectPath);
                    Trace.trace("appahscF", "socket = " + hscProviderSocket);
                    Trace.trace("appahscF", "handle = " + cIMOMHandle);
                    Trace.trace("appahscF", "bootModeValue = " + n);
                    this._theLPAR = by;
                    this._profileTimeStamp = string;
                    this._socket = hscProviderSocket;
                    this._partitionOP = cIMObjectPath;
                    this._cimomHandle = (ProviderCIMOMHandle)cIMOMHandle;
                    this._bootMode = n;
                    CIMInstance cIMInstance = null;
                    try {
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        throw new HSCCIMException("1586", new String[]{cIMObjectPath.toString()});
                    }
                    Trace.trace("appahscF", "partitionInstance = " + cIMInstance);
                    this._partitionName = (String)cIMInstance.getProperty("Name").getValue().getValue();
                    this._lparUserDefName = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                    this._partitionType = ((UnsignedInt8)cIMInstance.getProperty("PartitionType").getValue().getValue()).intValue();
                    if (this._partitionType == 3 || this._partitionType == 2) {
                        this._isPhysicalPartition = true;
                        this._partitionPhysicalLocCode = (String)cIMInstance.getProperty("PhysLocCode").getValue().getValue();
                        this._partitionAffinityGroup = (String)cIMInstance.getProperty("AffinityGroupID").getValue().getValue();
                    }
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("_partitionName = " + this._partitionName);
                        System.out.println("_lparUserDefName = " + this._lparUserDefName);
                    }
                    int n3 = this._partitionName.indexOf(42);
                    this._cecNameStr = this._partitionName.substring(n3 + 1);
                    Trace.trace("appahscD", "_cecNameStr = " + this._cecNameStr);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)this._cecNameStr));
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath2, this._cimomHandle.getClass(cIMObjectPath2, false), false);
                    this._cecUserDefName = (String)CimomWrapper.getProperty(cIMInstance2, "UserDefinedName");
                    try {
                        this._cspVersion = (String)CimomWrapper.getProperty(cIMInstance2, "CSPVersion");
                        this._cspMappedVer = VersionComparator.CSPVersionValue(this._cspVersion);
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    this._setIndexByVersion(this._cspMappedVer);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("_cecUserDefName = " + this._cecUserDefName);
                    }
                    this._updateCIMOM = false;
                    this._procSequence = new Vector();
                    if (!this._isPhysicalPartition) {
                        this._procSequence.addElement(new Byte(0));
                        this._procSequence.addElement(new Byte(1));
                        this._procSequence.addElement(new Byte(6));
                        this._procSequence.addElement(new Byte(7));
                        this._procSequence.addElement(new Byte(2));
                        this._procSequence.addElement(new Byte(3));
                        this._procSequence.addElement(new Byte(4));
                        this._procSequence.addElement(new Byte(5));
                        this._procSequence.addElement(new Byte(8));
                        this._procSequence.addElement(new Byte(9));
                        this._procSequence.addElement(new Byte(14));
                        this._procSequence.addElement(new Byte(15));
                        this._procSequence.addElement(new Byte(10));
                        this._procSequence.addElement(new Byte(11));
                        this._procSequence.addElement(new Byte(12));
                        this._procSequence.addElement(new Byte(13));
                        this._procSequence.addElement(new Byte(16));
                        this._procSequence.addElement(new Byte(17));
                        this._procSequence.addElement(new Byte(22));
                        this._procSequence.addElement(new Byte(23));
                        this._procSequence.addElement(new Byte(18));
                        this._procSequence.addElement(new Byte(19));
                        this._procSequence.addElement(new Byte(20));
                        this._procSequence.addElement(new Byte(21));
                        this._procSequence.addElement(new Byte(24));
                        this._procSequence.addElement(new Byte(25));
                        this._procSequence.addElement(new Byte(30));
                        this._procSequence.addElement(new Byte(31));
                        this._procSequence.addElement(new Byte(26));
                        this._procSequence.addElement(new Byte(27));
                        this._procSequence.addElement(new Byte(28));
                        this._procSequence.addElement(new Byte(29));
                    }
                    Hashtable hashtable = null;
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, this._socket, this._cspVersion);
                    int n4 = (Integer)hashtable.get("CEC_STATE");
                    hashtable = HscProviderUtils.getCapabilities(this._cspVersion, this._socket);
                    int n5 = (Integer)hashtable.get("CecMode");
                    this._cspCapability = ((Integer)hashtable.get("CecCapability")).shortValue();
                    this._cspRunTimeCap = ((Integer)hashtable.get("RuntimeCapability")).shortValue();
                    if (this._cspMappedVer == -1) {
                        throw new HSCCIMException("05E9");
                    }
                    if (this._cspMappedVer >= 2000) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_PARTITION_MODE", null, this._socket, this._cspVersion);
                        this._partitionMode = (Integer)hashtable.get("MODE");
                    } else {
                        this._partitionMode = 1;
                    }
                    if (this._theLPAR == 0) {
                        if (n4 != 3) {
                            throw new HSCCIMException("058E");
                        }
                        if ((this._cspCapability & 1) == 0) {
                            throw new HSCCIMException("0596");
                        }
                        int n6 = 1;
                        if (this._profileTimeStamp != null) {
                            if (this._bootMode == 0) {
                                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                                cIMObjectPath3.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                                cIMObjectPath3.addKey("PartitionName", new CIMValue((Object)this._partitionName));
                                cIMObjectPath3.addKey("SettingID", new CIMValue((Object)this._profileTimeStamp));
                                CIMInstance cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath3, new CIMClass("IBMHSC_LparProfile"), false);
                                if (cIMInstance3 != null) {
                                    CIMProperty cIMProperty = cIMInstance3.getProperty("BootMode");
                                    n6 = ((UnsignedInt8)cIMProperty.getValue().getValue()).intValue();
                                }
                            } else {
                                n6 = this._bootMode;
                            }
                        }
                        HscProviderUtils.doCSPCommand("SET_CEC_POWER_ON_OFF", new String[]{Integer.toHexString(n6), "0"}, this._socket, this._cspVersion);
                        break block72;
                    }
                    if (n4 == 3) {
                        throw new HSCCIMException("058F");
                    }
                    if (n5 == 0) {
                        throw new HSCCIMException("0590");
                    }
                    if ((this._cspCapability & 2) == 0 && !this._isPhysicalPartition) {
                        throw new HSCCIMException("0597");
                    }
                    if ((this._cspRunTimeCap & 8) == 0 && this._isPhysicalPartition) {
                        throw new HSCCIMException("0598");
                    }
                    if (this._partitionMode == 0 && this._cspMappedVer >= 2000) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_ALL_LPAR_DEFINITION_FIELDS", null, this._socket, this._cspVersion);
                        stringArray = (Vector)hashtable.get("ALL_LPAR_DEFINITION_FIELDS");
                        System.out.println("allPartDefStates = " + stringArray);
                        if (stringArray != null && stringArray.size() != 0) {
                            n2 = 0;
                            while (n2 < stringArray.size()) {
                                short s;
                                object = (String[])stringArray.elementAt(n2);
                                int n7 = (Integer)((Hashtable)object).get("SLOT_DEFINITION");
                                if (n7 == 10 && (s = ((Integer)((Hashtable)object).get("TYPE_VALUE")).shortValue()) != this._partitionType) {
                                    System.out.println("Not the same type, so mark the partition, " + (n2 + 1) + " to invalid");
                                    HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", new String[]{Integer.toHexString(n2 + 1), Integer.toHexString(11)}, hscProviderSocket, this._cspVersion);
                                    System.out.println("INVALIDATED! wrong type!");
                                }
                                ++n2;
                            }
                        }
                    }
                    if (!this._isPhysicalPartition && this._partitionMode != 0 && this._partitionMode != 1) {
                        throw new HSCCIMException("0591");
                    }
                    if (this._partitionType == 2 && this._partitionMode == 1) {
                        throw new HSCCIMException("0592");
                    }
                    if (this._partitionType == 3 && this._partitionMode != 0 && this._partitionMode != 3) {
                        throw new HSCCIMException("0593");
                    }
                    stringArray = new String[]{Integer.toHexString(this._theLPAR)};
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", stringArray, this._socket, this._cspVersion);
                    this._theLPAROpState = ((Integer)hashtable.get("LPAR_STATE")).byteValue();
                    Trace.trace("appahscF", "_theLPAROpState = " + this._theLPAROpState);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("_theLPAROpState = " + this._theLPAROpState);
                    }
                    if (this._theLPAROpState == 13 || this._theLPAROpState == 8 || this._theLPAROpState == 5 || this._theLPAROpState == 9) {
                        String string2 = "";
                        switch (this._theLPAROpState) {
                            case 8: {
                                string2 = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_RUNNING");
                                break;
                            }
                            case 5: {
                                string2 = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_BOOTING");
                                break;
                            }
                            case 9: {
                                string2 = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_OPEN_FIRMWARE");
                                break;
                            }
                            case 13: {
                                string2 = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_NOT_READY");
                            }
                        }
                        throw new HSCCIMException("05EA", new String[]{string2});
                    }
                    if (this._theLPAROpState == 12) {
                        n2 = 0;
                        try {
                            stringArray = new String[]{Integer.toHexString(this._theLPAR)};
                            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_BOOT_ERROR_VALUES", stringArray, this._socket, this._cspVersion);
                            n2 = ((Integer)hashtable.get("BOOT_ERROR")).byteValue();
                            Trace.trace("appahscD", "errorValue = " + n2);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("boot error value = " + n2);
                        }
                        try {
                            stringArray = new String[]{Integer.toHexString(this._theLPAR)};
                            hashtable = HscProviderUtils.doCSPCommand("CLEAR_LPAR_BOOT_ERROR_VALUES", stringArray, this._socket, this._cspVersion);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        }
                        try {
                            object = new String[]{String.valueOf(n2), this._lparUserDefName, String.valueOf(this._theLPAR), this._cecNameStr, "LPAR Activation"};
                            String string3 = "Boot error value: " + object[0] + " of logical partition " + object[1] + " with ID " + object[2] + " at CEC " + object[3] + " is cleared during " + object[4] + " process ";
                            HSCLogUtils.logSystemEvent((short)2041, string3, (String[])object, null);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        }
                    }
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("before check definition state");
                    }
                    stringArray = new String[]{Integer.toHexString(this._theLPAR)};
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, this._socket, this._cspVersion);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("before parse reponse of def state");
                    }
                    this._theLPARDefState = ((Integer)hashtable.get("DEFINITION_STATE")).byteValue();
                    Trace.trace("appahscF", "_theLPARDefState = " + this._theLPARDefState);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("_theLPARDefState = " + this._theLPARDefState);
                    }
                    if (this._theLPARDefState == 4) {
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("CEC_STATE_UNDEFINED");
                        }
                        throw new HSCCIMException("05E0", new String[]{this._lparUserDefName});
                    }
                    String string4 = null;
                    this._nvram = (NVRAM)NVRAM.NVRAM_TABLE.get(this._cecNameStr);
                    if (this._nvram == null) {
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("_nvram is null");
                        }
                        throw new HSCCIMException("0005");
                    }
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("_nvram is not equal to 0");
                    }
                    object = null;
                    if (this._profileTimeStamp != null && !this._profileTimeStamp.equals("")) {
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("inParams' size is not equal 1");
                        }
                        if (!this._nvram.existInPartition(this._theLPAR, this._profileTimeStamp)) {
                            throw new HSCCIMException("05E7", new String[]{this._lparUserDefName});
                        }
                        object = this._nvram.getLPARProfile(this._profileTimeStamp, this._socket);
                        Trace.trace("appahscF", "properties = " + object);
                        if (object == null) {
                            throw new HSCCIMException("07DA");
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("properties = " + object);
                        }
                    } else {
                        object = this._nvram.getDefaultLPARProfile(this._theLPAR, this._socket);
                        Trace.trace("appahscF", "properties = " + object);
                        if (object == null) {
                            throw new HSCCIMException("07DA");
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("properties = " + object);
                        }
                        this._profileTimeStamp = (String)((CIMProperty)((Vector)object).get(this._versionLparProfId)).getValue().getValue();
                        Trace.trace("appahscD", "_profileTimeStamp = " + this._profileTimeStamp);
                        string4 = (String)((CIMProperty)((Vector)object).get(this._versionLparProfUsrDefName)).getValue().getValue();
                        Trace.trace("appahscD", "profileName = " + string4);
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("profileName = " + string4);
                        }
                    }
                    this.activateProf((Vector)object);
                    if (!this._updateCIMOM) break block72;
                    try {
                        this.updateCIMOMCache();
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                    this._updateCIMOM = false;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("05E9");
                    }
                    throw (HSCCIMException)((Object)throwable);
                }
            }
            Object var20_34 = null;
        }
        catch (Throwable throwable) {
            Object var20_35 = null;
            Trace.trace("appahscT", "<- activator");
            throw throwable;
        }
        Trace.trace("appahscT", "<- activator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateProf(Vector vector) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In activateProf");
        }
        Trace.trace("appahscT", "-> activateProf");
        Trace.trace("appahscF", "profileProperties = " + vector);
        Hashtable hashtable = null;
        this._invalidLPARs = new Vector();
        this._ioAssignment = new Hashtable();
        this._ioReassignment = new Hashtable();
        this._ioFree = new Hashtable();
        this._cpuAssignment = new Hashtable();
        this._cpuReassignment = new Hashtable();
        this._memoryAssigned = 0L;
        this._lparOpState = null;
        this._lparDefState = null;
        this._ioSlotsToCheck = new Hashtable();
        this._cpusToCheck = new Hashtable();
        try {
            long l;
            int n;
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("properties = " + vector);
            }
            System.out.println("^^^^^^^^^ Activator->profile is: " + this._profileTimeStamp + "\n Default profile is: " + ((NVRAM)NVRAM.NVRAM_TABLE.get(this._cecNameStr)).getDefaultLPARProfile(this._theLPAR, this._socket));
            Vector vector2 = ((NVRAM)NVRAM.NVRAM_TABLE.get(this._cecNameStr)).getDefaultLPARProfile(this._theLPAR, this._socket);
            String string = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            boolean bl = CecUpdater.isFastActivate(new Short(this._theLPAR), this._cecNameStr, this._socket);
            System.out.println("################## DEF PROFILE #######>>> " + string);
            System.out.println("################## PROF TIMESTAMP ####>>> " + this._profileTimeStamp);
            boolean bl2 = false;
            if (bl && !string.equals(this._profileTimeStamp) || !bl) {
                System.out.println("#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#");
                System.out.println("################### NOT FAST ACTIVATE IN ACTIVATOR #######");
                bl2 = this.allocateIO((CIMProperty)vector.get(this._versionLparProfDraInfo), (CIMProperty)vector.get(this._versionLparProfSlotInfo), (CIMProperty)vector.get(this._versionLparProfReqDes));
                n = 0;
                int n2 = 0;
                if (!this._isPhysicalPartition) {
                    n = ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfReqCpu)).getValue().getValue()).intValue();
                    Trace.trace("appahscF", "requiredCPU = " + n);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("requiredCPU = " + n);
                    }
                    n2 = ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfDesCpu)).getValue().getValue()).intValue();
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("desiredCPU = " + n2);
                    }
                    Trace.trace("appahscF", "desiredCPU = " + String.valueOf(n2));
                }
                this.allocateCPU(n, n2);
                if (!this._isPhysicalPartition) {
                    if (this._cspMappedVer >= 3000) {
                        this._maxMem = ((UnsignedInt32)((CIMProperty)vector.get(this._versionLparProfMaxMem)).getValue().getValue()).longValue();
                    }
                    long l2 = ((UnsignedInt32)((CIMProperty)vector.get(this._versionLparProfReqMem)).getValue().getValue()).longValue();
                    Trace.trace("appahscF", "requiredMem = " + l2);
                    l = ((UnsignedInt32)((CIMProperty)vector.get(this._versionLparProfDesMem)).getValue().getValue()).longValue();
                    Trace.trace("appahscF", "desiredMem = " + String.valueOf(l));
                    if (l2 != 0L || l != 0L) {
                        this.allocateMemory(l2, l, this._maxMem);
                    }
                }
                if (this._cspMappedVer >= 4000) {
                    int n3 = ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfSMAMode)).getValue().getValue()).intValue();
                    Vector vector3 = (Vector)((CIMProperty)vector.get(this._versionLparProfSMADevID)).getValue().getValue();
                    System.out.println("smaDeviceIDs: " + vector3);
                    Vector vector4 = (Vector)((CIMProperty)vector.get(this._versionLparProfSMAWindows)).getValue().getValue();
                    System.out.println("Windows vector: " + vector4);
                    this.allocateSMA(n3, vector3, vector4);
                }
                if (this._theLPARDefState == 10) {
                    hashtable = HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(11)}, this._socket, this._cspVersion);
                    System.out.println("INVALIDATED the LPAR we're activating");
                }
                this.setCSPResources();
                this._updateCIMOM = true;
                byte by = ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfSerAuth)).getValue().getValue()).byteValue();
                Trace.trace("appahscF", "serviceAuth = " + by);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("serviceAuth = " + by);
                }
                hashtable = HscProviderUtils.doCSPCommand("SET_LPAR_POLICIES", new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(by)}, this._socket, this._cspVersion);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("After SET_LPAR_POLICIES");
                }
                if (this._cspMappedVer >= 3000) {
                    byte by2 = ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfRMOSize)).getValue().getValue()).byteValue();
                    Trace.trace("appahscF", "rmoSize = " + by2);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("rmoSize = " + by2);
                    }
                    HscProviderUtils.doCSPCommand("SET_LPAR_TYPE", new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(this._partitionType), Integer.toHexString(by2)}, this._socket, this._cspVersion);
                    try {
                        CIMInstance cIMInstance = null;
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, new CIMClass("IBMHSC_Partition"), false);
                        cIMInstance.setProperty("RuntimeRMOSize", new CIMValue((Object)new UnsignedInt8((short)by2)));
                        CimomWrapper.setInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, cIMInstance);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                }
                hashtable = HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(10)}, this._socket, this._cspVersion);
            } else {
                bl2 = true;
            }
            n = this._bootMode == 0 ? ((UnsignedInt8)((CIMProperty)vector.get(this._versionLparProfbooMod)).getValue().getValue()).byteValue() : (int)this._bootMode;
            Trace.trace("appahscF", "bootMode = " + n);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("bootMode = " + n);
            }
            hashtable = HscProviderUtils.doCSPCommand("BOOT_LPAR_TO_BOOT_MODE_VALUE", new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(n)}, this._socket, this._cspVersion);
            Trace.trace("appahscF", "_procIDForUpdateMemory = " + this._procIDForUpdateMemory);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("_procIDForUpdateMemory = " + this._procIDForUpdateMemory);
            }
            if (this._procIDForUpdateMemory != -1) {
                try {
                    long l3 = 0L;
                    while (l3 <= this._maxUpdatePollTime) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_PROC_STATE", new String[]{Integer.toHexString(this._procIDForUpdateMemory)}, this._socket, this._cspVersion);
                        int n4 = (Integer)hashtable.get("PROC_STATE");
                        System.out.println("processorState = " + n4);
                        if (n4 == 8) {
                            hashtable = null;
                            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(this._theLPAR)}, this._socket, this._cspVersion);
                            l = (Long)hashtable.get("TOT_ALLOC_MEMORY");
                            long l4 = (Long)hashtable.get("PAGE_TABLE_ALLOC_MEMORY");
                            Trace.trace("appahscF", "allocMem = " + l);
                            Trace.trace("appahscF", "pageMem = " + l4);
                            CIMInstance cIMInstance = null;
                            try {
                                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, new CIMClass("IBMHSC_Partition"), false);
                                cIMInstance.setProperty("AllocatedMemory", new CIMValue((Object)new UnsignedInt32(l)));
                                cIMInstance.setProperty("PageTableMemory", new CIMValue((Object)new UnsignedInt32(l4)));
                                CimomWrapper.setInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, cIMInstance);
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            }
                            break;
                        }
                        Thread.sleep(this._updatePollFreq);
                        l3 += this._updatePollFreq;
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                }
            }
            this._nvram.setActivatedLPARProfile(this._theLPAR, this._profileTimeStamp, this._socket);
            if (!bl2) {
                this._nvram.setFastActivation(this._theLPAR, false, this._socket);
            }
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_VIRTUAL_ACTIVATE", new String[]{"0", HscProviderUtils.getHscID((CIMOMHandle)this._cimomHandle), "2", "16", Integer.toHexString(this._theLPAR), this._profileTimeStamp}, this._socket, this._cspVersion);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            }
            try {
                OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(this._cecNameStr);
                opPanelPoller.setMaxPollFreq(this._theLPAR, 5);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            }
        }
        finally {
            Trace.trace("appahscT", "<- activateProf");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of activateProf");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean allocateIO(CIMProperty var1_1, CIMProperty var2_2, CIMProperty var3_3) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In allocateIO");
        }
        Trace.trace("appahscT", "-> allocateIO");
        Trace.trace("appahscF", "drawers = " + var1_1);
        Trace.trace("appahscF", "slots = " + var2_2);
        Trace.trace("appahscF", "requireDesire = " + var3_3);
        try {
            var4_4 = new Hashtable<String[], Object>();
            var5_6 = new Hashtable<String[], Object>();
            var6_7 = null;
            var7_8 = null;
            var8_9 = null;
            if (var1_1 != null) {
                var6_7 = (Vector)var1_1.getValue().getValue();
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("wantedDrawers = " + var6_7);
            }
            Trace.trace("appahscD", "wantedDrawers = " + var6_7);
            if (var2_2 != null) {
                var7_8 = (Vector)var2_2.getValue().getValue();
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("wantedSlots = " + var7_8);
            }
            Trace.trace("appahscD", "wantedSlots = " + var7_8);
            if (var3_3 != null) {
                var8_9 = (Vector)var3_3.getValue().getValue();
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("reqDezInfo = " + var8_9);
            }
            Trace.trace("appahscD", "requiredDesireInfo = " + var8_9);
            var9_10 = 0;
            if (var6_7 == null || var6_7.isEmpty()) {
                var9_10 = 0;
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("wantedDrawers == null");
                }
            } else {
                var9_10 = var6_7.size();
            }
            Trace.trace("appahscD", "number of slots = " + String.valueOf(var9_10));
            var10_11 = 0;
            while (var10_11 < var9_10) {
                var11_12 = (String)var8_9.get(var10_11);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("requireOrDesire[" + var10_11 + "] = " + (String)var11_12);
                }
                Trace.trace("appahscF", "requireOrDesire[" + String.valueOf(var10_11) + "] = " + (String)var11_12);
                var12_13 /* !! */  = (String)var6_7.get(var10_11);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("id[" + var10_11 + "] = " + (String)var12_13 /* !! */ );
                }
                Trace.trace("appahscF", "id[" + String.valueOf(var10_11) + "] = " + (String)var12_13 /* !! */ );
                var13_14 = ((UnsignedInt8)var7_8.get(var10_11)).byteValue();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("slotNum[" + var10_11 + "] = " + var13_14);
                }
                Trace.trace("appahscF", "slotNum[" + String.valueOf(var10_11) + "] = " + String.valueOf(var13_14));
                if (var11_12.equalsIgnoreCase("r")) {
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("REQUIRED");
                    }
                    if (var5_6.containsKey(var12_13 /* !! */ )) {
                        var14_15 = (Vector)var5_6.get(var12_13 /* !! */ );
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var14_15.add(new Byte((byte)var13_14));
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var5_6.put(var12_13 /* !! */ , var14_15);
                    } else {
                        var14_15 = new Vector<E>();
                        var14_15.add(new Byte((byte)var13_14));
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var5_6.put(var12_13 /* !! */ , var14_15);
                    }
                } else {
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("DESIRED");
                    }
                    if (var4_4.containsKey(var12_13 /* !! */ )) {
                        var14_15 = (Vector)var4_4.get(var12_13 /* !! */ );
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var14_15.add(new Byte((byte)var13_14));
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var4_4.put(var12_13 /* !! */ , var14_15);
                    } else {
                        var14_15 = new Vector<E>();
                        var14_15.add(new Byte((byte)var13_14));
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var14_15);
                        }
                        var4_4.put(var12_13 /* !! */ , var14_15);
                    }
                }
                ++var10_11;
            }
            var11_12 = HscProviderUtils.doCSPCommand("GET_NUM_IO_DRAWERS", null, this._socket, this._cspVersion);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("after getting response from getNUMIODrawres");
            }
            var12_13 /* !! */  = (String[])var11_12.get("DRAWER_IDS");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("after parse the drawerIDs out");
            }
            var13_14 = (Integer)var11_12.get("NUM_IO_DRAWERS");
            Trace.trace("appahscF", "numDrawers = " + var13_14);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("numDrawers = " + var13_14);
                System.out.println("after parse the num of drawers out");
            }
            var15_16 = true;
            var16_17 = 0;
            while (var16_17 < var13_14) {
                var14_15 = new String[1];
                var17_18 = var12_13 /* !! */ [var16_17];
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("drawerID = " + var17_18);
                }
                Trace.trace("appahscF", "drawerID = " + var17_18);
                var14_15[0] = var17_18;
                var11_12 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", (String[])var14_15, this._socket, this._cspVersion);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("after the getIODrawerInfo command");
                }
                var18_21 = (Hashtable)var11_12.get("SLOT_INFORMATION");
                var19_23 = (Integer)var11_12.get("NUM_SLOTS");
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("number of slots" + var19_23);
                }
                Trace.trace("appahscF", "numSlots = " + var19_23);
                var20_24 = new Hashtable<Byte, Byte>();
                var21_25 = new Vector<Byte>();
                var22_26 = 0;
                while (var22_26 < var19_23) {
                    block131: {
                        block132: {
                            block130: {
                                var23_27 = (Hashtable)var18_21.get(new Integer(var22_26));
                                var24_28 = new Byte(((Integer)var23_27.get("SLOT_NO")).byteValue());
                                Trace.trace("appahscF", "slotID = " + var24_28);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("slotID = " + var24_28);
                                }
                                var25_30 = new Byte(((Integer)var23_27.get("LPAR_ID")).byteValue());
                                Trace.trace("appahscF", "lparID = " + var25_30);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("lparID = " + var25_30);
                                }
                                var26_31 = (Integer)var23_27.get("IO_STATE");
                                Trace.trace("appahscF", "ioSlotState = " + var26_31);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("ioSlotState = " + var26_31);
                                }
                                var27_32 = (Integer)var23_27.get("IO_STATUS");
                                Trace.trace("appahscF", "ioSlotStatus = " + var27_32);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("ioSlotStatus = " + var27_32);
                                }
                                if (var25_30 != this._theLPAR) break block130;
                                var28_33 = false;
                                if (var5_6 == null || !var5_6.containsKey(var17_18)) ** GOTO lbl179
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("checking required");
                                }
                                var29_37 = (Vector)var5_6.get(var17_18);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("content = " + var29_37);
                                }
                                if (var29_37 == null || !var29_37.contains(var24_28)) ** GOTO lbl179
                                if (var26_31 == 8) {
                                    throw new HSCCIMException("03F0", new String[]{var17_18, var24_28.toString(), var25_30.toString()});
                                }
                                if (var26_31 == 12) {
                                    var21_25.add(var24_28);
                                } else {
                                    if (var27_32 == 0) {
                                        throw new HSCCIMException("03F2", new String[]{var17_18, var24_28.toString()});
                                    }
                                    if (var27_32 == 2) {
                                        throw new HSCCIMException("03F3", new String[]{var17_18, var24_28.toString()});
                                    }
                                    var20_24.put(var24_28, var25_30);
                                    var29_37.remove(var24_28);
                                    if (var29_37.isEmpty()) {
                                        var5_6.remove(var17_18);
                                    }
                                    var28_33 = true;
                                    var30_38 = new Vector<E>();
                                    if (this._ioSlotsToCheck.containsKey(var17_18)) {
                                        var30_38 = (Vector)this._ioSlotsToCheck.get(var17_18);
                                    }
                                    Trace.trace("appahscD", "value = " + var30_38);
                                    var30_38.addElement(var24_28);
                                    this._ioSlotsToCheck.put(var17_18, var30_38);
lbl179:
                                    // 3 sources

                                    if (var4_4 != null && var4_4.containsKey(var17_18)) {
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("checking desired");
                                        }
                                        var29_37 = (Vector)var4_4.get(var17_18);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("content = " + var29_37);
                                        }
                                        if (var29_37 != null && var29_37.contains(var24_28)) {
                                            var29_37.remove(var24_28);
                                            if (var29_37.isEmpty()) {
                                                var4_4.remove(var17_18);
                                            }
                                            if (var26_31 == 7 && var27_32 == 128 && !var28_33) {
                                                var28_33 = true;
                                                var30_38 = new Vector();
                                                var20_24.put(var24_28, var25_30);
                                                if (this._ioSlotsToCheck.containsKey(var17_18)) {
                                                    var30_38 = (Vector)this._ioSlotsToCheck.get(var17_18);
                                                }
                                                Trace.trace("appahscD", "value = " + var30_38);
                                                var30_38.addElement(var24_28);
                                                this._ioSlotsToCheck.put(var17_18, var30_38);
                                            }
                                        }
                                    }
                                    if (!var28_33) {
                                        var29_37 = (Vector)this._ioFree.get(var17_18);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("slotFree = " + var29_37);
                                        }
                                        if (var29_37 == null) {
                                            var29_37 = new Vector();
                                        }
                                        var29_37.add(var24_28);
                                        this._ioFree.put(var17_18, var29_37);
                                    }
                                }
                                break block131;
                            }
                            if (var25_30 != 0) break block132;
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("lparID == 0");
                            }
                            var28_34 = false;
                            if (var5_6 == null || !var5_6.containsKey(var17_18)) ** GOTO lbl267
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("checking required");
                            }
                            var29_37 = (Vector)var5_6.get(var17_18);
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("content = " + var29_37);
                            }
                            if (var29_37 == null || !var29_37.contains(var24_28)) ** GOTO lbl267
                            if (var26_31 == 8) {
                                throw new HSCCIMException("03F0", new String[]{var17_18, var24_28.toString(), var25_30.toString()});
                            }
                            if (var26_31 == 12) {
                                var21_25.add(var24_28);
                            } else {
                                if (var27_32 == 0) {
                                    throw new HSCCIMException("03F2", new String[]{var17_18, var24_28.toString()});
                                }
                                if (var27_32 == 2) {
                                    throw new HSCCIMException("03F3", new String[]{var17_18, var24_28.toString()});
                                }
                                var20_24.put(var24_28, var25_30);
                                var29_37.remove(var24_28);
                                if (var29_37.isEmpty()) {
                                    var5_6.remove(var17_18);
                                }
                                if (this._ioReassignment.containsKey(var17_18)) {
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("_ioReassigment constain drawerID");
                                    }
                                    ((Vector)this._ioReassignment.get(var17_18)).add(var24_28);
                                } else {
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("_ioReassignment doesn't not contain drawerID");
                                    }
                                    var30_38 = new Vector();
                                    var30_38.add(var24_28);
                                    this._ioReassignment.put(var17_18, var30_38);
                                }
                                var28_34 = true;
                                var30_38 = new Vector<E>();
                                if (this._ioSlotsToCheck.containsKey(var17_18)) {
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("_ioSlotsToCheck doesn't not contain drawerID");
                                    }
                                    var30_38 = (Vector)this._ioSlotsToCheck.get(var17_18);
                                }
                                if (var30_38 == null) {
                                    var30_38 = new Vector();
                                }
                                Trace.trace("appahscD", "value = " + var30_38);
                                var30_38.addElement(var24_28);
                                this._ioSlotsToCheck.put(var17_18, var30_38);
lbl267:
                                // 3 sources

                                if (var4_4 != null && var4_4.containsKey(var17_18)) {
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("checking desired");
                                    }
                                    var29_37 = (Vector)var4_4.get(var17_18);
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + var29_37);
                                    }
                                    if (var29_37 != null && var29_37.contains(var24_28)) {
                                        if (var26_31 == 7) {
                                            if (var27_32 == 128) {
                                                if (!var28_34) {
                                                    var20_24.put(var24_28, var25_30);
                                                    if (this._ioReassignment.containsKey(var17_18)) {
                                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                                            System.out.println("_ioReassignment contain drawerID");
                                                        }
                                                        ((Vector)this._ioReassignment.get(var17_18)).add(var24_28);
                                                    } else {
                                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                                            System.out.println("_ioReassignment doesn't contain drawerID");
                                                        }
                                                        var30_38 = new Vector<E>();
                                                        var30_38.add(var24_28);
                                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                                            System.out.println("_ioReassignment = " + this._ioReassignment);
                                                        }
                                                        this._ioReassignment.put(var17_18, var30_38);
                                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                                            System.out.println("_ioReassignment = " + this._ioReassignment);
                                                        }
                                                    }
                                                    var30_38 = new Vector<E>();
                                                    if (this._ioSlotsToCheck.containsKey(var17_18)) {
                                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                                            System.out.println("_ioSlotsToCheck contain drawerID");
                                                        }
                                                        var30_38 = (Vector)this._ioSlotsToCheck.get(var17_18);
                                                    }
                                                    if (var30_38 == null) {
                                                        var30_38 = new Vector<E>();
                                                    }
                                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                                        System.out.println("value = " + var30_38);
                                                    }
                                                    var30_38.addElement(var24_28);
                                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                                        System.out.println("value = " + var30_38);
                                                    }
                                                    this._ioSlotsToCheck.put(var17_18, var30_38);
                                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                                        System.out.println("_ioSlotsToCheck = " + this._ioSlotsToCheck);
                                                    }
                                                }
                                            } else {
                                                var15_16 = false;
                                            }
                                        } else {
                                            var15_16 = false;
                                        }
                                        var29_37.remove(var24_28);
                                        if (var29_37.isEmpty()) {
                                            var4_4.remove(var17_18);
                                        }
                                    }
                                }
                            }
                            break block131;
                        }
                        if (var5_6 == null || !var5_6.containsKey(var17_18)) ** GOTO lbl342
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("checking required");
                        }
                        var28_35 = (Vector)var5_6.get(var17_18);
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("content = " + var28_35);
                        }
                        if (var28_35 == null || !var28_35.contains(var24_28)) ** GOTO lbl342
                        if (var26_31 == 8) {
                            throw new HSCCIMException("03F0", new String[]{var17_18, var24_28.toString(), var25_30.toString()});
                        }
                        if (var26_31 == 12) {
                            var21_25.add(var24_28);
                        } else {
                            if (var27_32 == 0) {
                                throw new HSCCIMException("03F2", new String[]{var17_18, var24_28.toString()});
                            }
                            if (var27_32 == 2) {
                                throw new HSCCIMException("03F3", new String[]{var17_18, var24_28.toString()});
                            }
                            var20_24.put(var24_28, var25_30);
lbl342:
                            // 3 sources

                            if (var4_4 != null && var4_4.containsKey(var17_18)) {
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("checking desired");
                                }
                                var28_36 = (Vector)var4_4.get(var17_18);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("content = " + var28_36);
                                }
                                if (var28_36 != null && var28_36.contains(var24_28)) {
                                    if (var26_31 == 7) {
                                        if (var27_32 == 128) {
                                            var20_24.put(var24_28, var25_30);
                                        } else {
                                            var15_16 = false;
                                            var28_36.remove(var24_28);
                                            if (var28_36.isEmpty()) {
                                                var4_4.remove(var17_18);
                                            }
                                        }
                                    } else {
                                        var15_16 = false;
                                        var28_36.remove(var24_28);
                                        if (var28_36.isEmpty()) {
                                            var4_4.remove(var17_18);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++var22_26;
                }
                if (var21_25 != null && !var21_25.isEmpty()) {
                    var23_27 = "";
                    var24_29 = 0;
                    while (var24_29 < var21_25.size()) {
                        var23_27 = var24_29 < var21_25.size() - 1 ? (String)var23_27 + var21_25.elementAt(var24_29).toString() + ", " : (String)var23_27 + var21_25.elementAt(var24_29);
                        ++var24_29;
                    }
                    throw new HSCCIMException("03F1", new String[]{var17_18, var23_27});
                }
                this._ioAssignment.put(var17_18, var20_24);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("_ioAssignment after");
                }
                ++var16_17;
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("requiredSlots = " + var5_6);
                System.out.println("desiredSlots = " + var4_4);
            }
            if ((var5_6 == null || var5_6.isEmpty()) && (var4_4 == null || var4_4.isEmpty())) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("no need to steal");
                }
                var17_19 = var15_16;
                return var17_19;
            }
            var17_20 = this.stealIO(var5_6, var4_4);
            if (var4_4.size() != 0) {
                var15_16 = false;
            }
            System.out.println("After steal; lost num: " + var17_20);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("after steal");
            }
            if (var17_20 > 0) {
                System.out.println("Throwing Recovery exception!");
                throw new HSCCIMException("2910");
            }
            var18_22 = var15_16;
            return var18_22;
        }
        catch (HSCCIMException var4_5) {
            var4_5.printStackTrace();
            throw var4_5;
        }
        finally {
            Trace.trace("appahscT", "<- allocIO");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of allocateIO");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int stealIO(Hashtable hashtable, Hashtable hashtable2) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In stealIO");
        }
        Trace.trace("appahscT", "-> stealIO");
        Trace.trace("appahscF", "slotRequired = " + hashtable2);
        Trace.trace("appahscF", "slotDesired = " + hashtable2);
        System.out.println("In StealIO!");
        int n = 0;
        try {
            int n2;
            byte by;
            Object object;
            Object object2;
            Hashtable hashtable3 = null;
            Object var5_5 = null;
            int n3 = 0;
            if (this._lparOpState == null) {
                this.buildLPARStateTable();
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                Trace.trace("appahscF", "drawerID = " + (String)object2);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("drawerID = " + (String)object2);
                }
                object = (Vector)hashtable.get(object2);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("content = " + object);
                }
                Trace.trace("appahscF", "contents = " + object);
                n3 = ((Vector)object).size();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("content's size = " + n3);
                }
                int n4 = 0;
                while (n4 < n3) {
                    Vector<Byte> vector;
                    byte by2 = (Byte)((Vector)object).get(n4);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("slotNum = " + by2);
                    }
                    Byte by3 = null;
                    if (this._ioAssignment.get(object2) == null) throw new HSCCIMException("03EB", new String[]{HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "IO_DRAWER_NOT_FOUND", "", new String[]{object2, String.valueOf(by2)})});
                    by3 = (Byte)((Hashtable)this._ioAssignment.get(object2)).get(new Byte(by2));
                    Trace.trace("appahscF", "assignedLPAR = " + by3);
                    if (by3 == null) {
                        throw new HSCCIMException("03EB", new String[]{HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "IO_DRAWER_NOT_FOUND", "", new String[]{object2, String.valueOf(by2)})});
                    }
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("assignedLPAR =  " + by3);
                    }
                    by = 0;
                    if (by3 == null) {
                        throw new HSCCIMException("03EB", new String[]{HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "IO_DRAWER_NOT_FOUND", "", new String[]{object2, String.valueOf(by2)})});
                    }
                    by = by3;
                    if (this._lparOpState == null) {
                        this.buildLPARStateTable();
                    }
                    byte by4 = 1;
                    by4 = by == 0 ? (byte)1 : this._lparOpState[by - 1];
                    Trace.trace("appahscF", "state = " + String.valueOf(by4));
                    if (by4 == 8 || by4 == 5 || by4 == 9) {
                        vector = "";
                        switch (by4) {
                            case 8: {
                                vector = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_RUNNING");
                                break;
                            }
                            case 5: {
                                vector = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_BOOTING");
                                break;
                            }
                            case 9: {
                                vector = HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "LPAR_STATE_OPEN_FIRMWARE");
                            }
                        }
                        System.out.println("LPAR is running!");
                        hashtable3 = HscProviderUtils.getCapabilities(this._cspVersion, this._socket);
                        n2 = (Integer)hashtable3.get("RuntimeCapability");
                        if ((n2 & 0x10) != 16 || !HscProviderUtils.checkPermission(new HscPermission("dlpar", HscPermission.HSC_ACTION_RESTORE), null)) throw new HSCCIMException("03EB", new String[]{HSCResourceBundleUtil.encodeNLSMsg("LPARBundle", "IO_CANNOT_STEAL", "", new String[]{object2, String.valueOf(by2), String.valueOf(by), vector})});
                        System.out.println("DLPAR capable, right permissions...");
                        System.out.println(++n);
                    } else {
                        if (by != 0 && this._lparDefState[by - 1] == 10) {
                            this._lparDefState[by - 1] = 11;
                            this._invalidLPARs.add(by3);
                        }
                        if (this._ioReassignment.containsKey(object2)) {
                            vector = (Vector)this._ioReassignment.get(object2);
                            vector.add(new Byte(by2));
                        } else {
                            vector = new Vector();
                            vector.add(new Byte(by2));
                            this._ioReassignment.put(object2, vector);
                        }
                        vector = new Vector<Byte>();
                        if (this._ioSlotsToCheck.containsKey(object2)) {
                            vector = (Vector<Byte>)this._ioSlotsToCheck.get(object2);
                        }
                        if (vector == null) {
                            vector = new Vector<Byte>();
                        }
                        vector.addElement(new Byte(by2));
                        this._ioSlotsToCheck.put(object2, vector);
                    }
                    ++n4;
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("No more required IO slots");
            }
            object2 = (Hashtable)hashtable2.clone();
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("has desired IO slots");
                }
                object = (String)enumeration.nextElement();
                Trace.trace("appahscF", "drawerID = " + (String)object);
                Vector vector = (Vector)((Hashtable)object2).get(object);
                Vector vector2 = (Vector)hashtable2.get(object);
                Trace.trace("appahscF", "content = " + vector);
                n3 = vector.size();
                int n5 = 0;
                while (n5 < n3) {
                    by = (Byte)vector.get(n5);
                    Trace.trace("appahscF", "slotNum = " + String.valueOf(by));
                    Byte by5 = null;
                    if (this._ioAssignment.get(object) != null) {
                        by5 = (Byte)((Hashtable)this._ioAssignment.get(object)).get(new Byte(by));
                        Trace.trace("appahscF", "assignedLPAR = " + by5);
                        byte by6 = 0;
                        if (by5 != null) {
                            by6 = by5;
                            n2 = 8;
                            n2 = by6 == 0 ? 1 : this._lparOpState[by6 - 1];
                            Trace.trace("appahscF", "state = " + String.valueOf(n2));
                            if (n2 == 8 || n2 == 5 || n2 == 9) {
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("@@@@@PartitionActivateMethProvProv: In stealIO - can't steal desired io");
                                }
                            } else {
                                Vector<Byte> vector3;
                                if (by6 != 0 && this._lparDefState[by6 - 1] == 10) {
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("The state of the stolen lpar is valid");
                                    }
                                    this._lparDefState[by6 - 1] = 11;
                                    this._invalidLPARs.add(by5);
                                }
                                if (this._ioReassignment.containsKey(object)) {
                                    vector3 = (Vector<Byte>)this._ioReassignment.get(object);
                                    vector3.add(new Byte(by));
                                    this._ioReassignment.put(object, vector3);
                                } else {
                                    vector3 = new Vector<Byte>();
                                    vector3.add(new Byte(by));
                                    this._ioReassignment.put(object, vector3);
                                }
                                vector3 = new Vector<Byte>();
                                if (this._ioSlotsToCheck.containsKey(object)) {
                                    vector3 = (Vector<Byte>)this._ioSlotsToCheck.get(object);
                                }
                                if (vector3 == null) {
                                    vector3 = new Vector<Byte>();
                                }
                                vector3.addElement(new Byte(by));
                                this._ioSlotsToCheck.put(object, vector3);
                                vector2.removeElementAt(n5);
                                if (vector2.isEmpty()) {
                                    hashtable2.remove(object);
                                }
                            }
                        }
                    }
                    ++n5;
                }
            }
        }
        finally {
            Trace.trace("appahscT", "<- stealIO");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of stealIO");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
        System.out.println("End of StealIO!");
        System.out.println("returning numlost= " + n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void allocateCPU(int n, int n2) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In allocateCPU");
        }
        Trace.trace("appahscT", "-> allocateCPU");
        Trace.trace("appahscF", "requiredAmount = " + n);
        Trace.trace("appahscF", "desiredAmount = " + n2);
        Hashtable hashtable = null;
        boolean bl = false;
        try {
            int n3;
            Object e;
            int n4;
            int n5;
            Object object;
            Vector vector;
            int n6;
            int n7;
            String[] stringArray = null;
            if (this._lparOpState == null) {
                this.buildLPARStateTable();
            }
            hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, this._socket, this._cspVersion);
            Vector vector2 = (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
            Trace.trace("appahscF", "assignments = " + vector2);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("CPU assignments = " + vector2);
            }
            int n8 = vector2.size();
            hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, this._socket, this._cspVersion);
            Vector vector3 = (Vector)hashtable.get("ALL_PROC_STATE");
            Trace.trace("appahscF", "procStates = " + vector3);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("procStates = " + vector3);
            }
            Vector<Integer> vector4 = new Vector<Integer>();
            if (vector3 != null && vector3.size() != 0) {
                vector4.setSize(vector3.size());
            }
            Hashtable hashtable2 = new Hashtable();
            if (!this._isPhysicalPartition) {
                if (n8 < 32) {
                    n7 = 31;
                    while (n7 > n8 - 1) {
                        this._procSequence.removeElement(new Byte((byte)n7));
                        --n7;
                    }
                }
                Trace.trace("appahscF", "_procSequence = " + this._procSequence);
            }
            if (this._isPhysicalPartition) {
                hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSOR_AFFINITY", null, this._socket, this._cspVersion);
                n7 = (Integer)hashtable.get("NUM_GROUPS");
                n6 = (Integer)hashtable.get("AFFINITY_TYPE");
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("affinity type = " + n6);
                }
                if ((vector = (Vector)hashtable.get("GROUP_LIST")) != null && vector.size() != 0) {
                    int n9 = 0;
                    while (n9 < vector.size()) {
                        Hashtable hashtable3 = (Hashtable)vector.elementAt(n9);
                        object = (String)hashtable3.get("PROC_GROUP_LOCATION");
                        if (this._partitionPhysicalLocCode.equals(object)) {
                            Vector vector5 = (Vector)hashtable3.get("PROC_GROUP_LIST");
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("procList = " + vector5);
                            }
                            if (this._partitionType == 3) {
                                if ((n6 & 4) != 4) {
                                    throw new HSCCIMException("0594");
                                }
                                this._cpusAllocateForPPAR = (Vector)vector5.clone();
                                break;
                            }
                            if (this._partitionType != 2) break;
                            if ((n6 & 2) != 2) {
                                throw new HSCCIMException("0595");
                            }
                            this._cpusAllocateForPPAR = new Vector();
                            n5 = (Integer)hashtable3.get("NUM_PROCESSORS");
                            if (this._partitionAffinityGroup.equals("0")) {
                                n4 = 0;
                                while (n4 < 4) {
                                    this._cpusAllocateForPPAR.add(vector5.elementAt(n4));
                                    ++n4;
                                }
                            } else {
                                if (!this._partitionAffinityGroup.equals("1")) break;
                                n4 = 4;
                                while (n4 < n5) {
                                    this._cpusAllocateForPPAR.add(vector5.elementAt(n4));
                                    ++n4;
                                }
                            }
                            break;
                        }
                        ++n9;
                    }
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("_cpusAllocateFroPPAR = " + this._cpusAllocateForPPAR);
                }
            }
            Vector<Integer> vector6 = new Vector<Integer>();
            n6 = n8 - 1;
            while (n6 >= 0) {
                int n10;
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("cpu id = " + n6);
                }
                byte by = ((Integer)vector2.get(n6)).byteValue();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("lpar = " + by);
                }
                Trace.trace("appahscF", "cpu[" + String.valueOf(n6) + "] = " + String.valueOf(by));
                if (by == 0) {
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("lpar is 0");
                    }
                    Byte by2 = new Byte(0);
                    n10 = (Integer)vector3.get(n6);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("procState = " + n10);
                    }
                    Trace.trace("appahscF", "procState = " + n10);
                    if (n10 == 7) {
                        stringArray = new String[]{Integer.toHexString(n6)};
                        hashtable = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray, this._socket, this._cspVersion);
                        int n11 = (Integer)hashtable.get("PROC_STATUS");
                        vector4.setElementAt(new Integer(n11), n6);
                        Trace.trace("appahscF", "procStatus = " + n11);
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("procStatus = " + n11);
                        }
                        if (n11 == 1 || n11 == 3) {
                            this._cpuAssignment.put(new Byte((byte)n6), by2);
                            if (hashtable2.containsKey(by2)) {
                                Vector vector7;
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("lparID 0 contained");
                                }
                                if ((vector7 = (Vector)hashtable2.get(by2)) == null) {
                                    Vector vector8 = new Vector();
                                }
                                if (this._cpusAllocateForPPAR != null) {
                                    if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                        this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                        this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        bl = true;
                                        if (this._procIDForUpdateMemory == -1) {
                                            this._procIDForUpdateMemory = n6;
                                        }
                                        System.out.println("atLeastOneCpu = true 1");
                                    }
                                } else {
                                    void var17_32;
                                    var17_32.add(new Byte((byte)n6));
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + var17_32);
                                    }
                                }
                            } else {
                                Vector<Byte> vector9 = new Vector<Byte>();
                                if (this._cpusAllocateForPPAR != null) {
                                    if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                        this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                        this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        bl = true;
                                        if (this._procIDForUpdateMemory == -1) {
                                            this._procIDForUpdateMemory = n6;
                                        }
                                        System.out.println("atLeastOneCpu = true 2");
                                    }
                                } else {
                                    vector9.add(new Byte((byte)n6));
                                    hashtable2.put(by2, vector9);
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + vector9);
                                    }
                                }
                            }
                        } else {
                            System.out.println("Deconfigured Processor --> " + n6);
                            if (!this._isPhysicalPartition) {
                                this._procSequence.removeElement(new Byte((byte)n6));
                            } else if (hashtable2.containsKey(by2)) {
                                Vector vector10;
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("lparID 0 contained");
                                }
                                if ((vector10 = (Vector)hashtable2.get(by2)) == null) {
                                    Vector vector11 = new Vector();
                                }
                                if (this._cpusAllocateForPPAR != null) {
                                    if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                        this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                        this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        System.out.println("Didn't set the atLeastOneCpu to true --> " + bl);
                                    }
                                } else {
                                    void var17_36;
                                    var17_36.add(new Byte((byte)n6));
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + var17_36);
                                    }
                                }
                            } else {
                                Vector<Byte> vector12 = new Vector<Byte>();
                                if (this._cpusAllocateForPPAR != null) {
                                    if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                        this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                        this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                        System.out.println("Didn't set the atLeastOneCpu to true --> " + bl);
                                    }
                                } else {
                                    vector12.add(new Byte((byte)n6));
                                    hashtable2.put(by2, vector12);
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + vector12);
                                    }
                                }
                            }
                        }
                    } else {
                        vector4.setElementAt(null, n6);
                        if (!this._isPhysicalPartition) {
                            this._procSequence.removeElement(new Byte((byte)n6));
                        } else if (hashtable2.containsKey(by2)) {
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("lparID 0 contained");
                            }
                            if ((object = (Vector)hashtable2.get(by2)) == null) {
                                object = new Vector<Byte>();
                            }
                            if (this._cpusAllocateForPPAR != null) {
                                if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                    this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                    this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                    this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                    System.out.println("not set atLeastOneCpu = true 3");
                                }
                            } else {
                                ((Vector)object).add(new Byte((byte)n6));
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("content = " + object);
                                }
                            }
                        } else {
                            object = new Vector();
                            if (this._cpusAllocateForPPAR != null) {
                                if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                    this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                    this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                    this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                    System.out.println("not set atLeastOneCpu = true 4");
                                }
                            } else {
                                ((Vector)object).add(new Byte((byte)n6));
                                hashtable2.put(by2, object);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("content = " + object);
                                }
                            }
                        }
                    }
                } else {
                    if (!this._isPhysicalPartition) {
                        this._procSequence.removeElement(new Byte((byte)n6));
                    }
                    byte by3 = this._lparOpState[by - 1];
                    Trace.trace("appahscF", "state = " + String.valueOf(by3));
                    if (by3 == 1 || by3 == 12 || by3 == 13) {
                        n10 = (Integer)vector3.get(n6);
                        Trace.trace("appahscF", "procState = " + n10);
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("procState = " + n10);
                        }
                        if (n10 == 7) {
                            stringArray = new String[]{Integer.toHexString(n6)};
                            hashtable = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray, this._socket, this._cspVersion);
                            int n12 = (Integer)hashtable.get("PROC_STATUS");
                            vector4.setElementAt(new Integer(n12), n6);
                            Trace.trace("appahscF", "procStatus = " + n12);
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("procStatus = " + n12);
                            }
                            if (n12 == 1 || n12 == 3) {
                                Byte by4 = new Byte(by);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("lparID = " + by4);
                                }
                                this._cpuAssignment.put(new Byte((byte)n6), by4);
                                if (hashtable2.containsKey(by4)) {
                                    Vector<Byte> vector13 = (Vector<Byte>)hashtable2.get(by4);
                                    if (vector13 == null) {
                                        vector13 = new Vector<Byte>();
                                    }
                                    vector13.add(new Byte((byte)n6));
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + vector13);
                                    }
                                } else {
                                    Vector<Byte> vector14 = new Vector<Byte>();
                                    vector14.add(new Byte((byte)n6));
                                    hashtable2.put(by4, vector14);
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("content = " + vector14);
                                    }
                                }
                            } else if (!this._isPhysicalPartition) {
                                this._cpuReassignment.put(new Byte((byte)n6), new Byte(0));
                                this._cpusToCheck.put(new Byte((byte)n6), new Byte(0));
                            } else {
                                Byte by5 = new Byte(by);
                                if (hashtable2.containsKey(by5)) {
                                    Vector<Byte> vector15;
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("lparID 0 contained");
                                    }
                                    if ((vector15 = (Vector<Byte>)hashtable2.get(by5)) == null) {
                                        vector15 = new Vector<Byte>();
                                    }
                                    if (this._cpusAllocateForPPAR != null) {
                                        if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                            this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                            this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            System.out.println("not set atLeastOneCpu = true 5");
                                        }
                                    } else {
                                        vector15.add(new Byte((byte)n6));
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("content = " + vector15);
                                        }
                                    }
                                } else {
                                    Vector<Byte> vector16 = new Vector<Byte>();
                                    if (this._cpusAllocateForPPAR != null) {
                                        if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                            this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                            this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            System.out.println("not set atLeastOneCpu = true 6");
                                        }
                                    } else {
                                        vector16.add(new Byte((byte)n6));
                                        hashtable2.put(by5, vector16);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("content = " + vector16);
                                        }
                                    }
                                }
                            }
                        } else {
                            vector4.setElementAt(null, n6);
                            if (!this._isPhysicalPartition) {
                                this._cpuReassignment.put(new Byte((byte)n6), new Byte(0));
                                this._cpusToCheck.put(new Byte((byte)n6), new Byte(0));
                            } else {
                                object = new Byte(by);
                                if (hashtable2.containsKey(object)) {
                                    Vector vector17;
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("lparID 0 contained");
                                    }
                                    if ((vector17 = (Vector)hashtable2.get(object)) == null) {
                                        Vector vector18 = new Vector();
                                    }
                                    if (this._cpusAllocateForPPAR != null) {
                                        if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                            this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                            this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            System.out.println("not set atLeastOneCpu = true 7");
                                        }
                                    } else {
                                        void var17_42;
                                        var17_42.add(new Byte((byte)n6));
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("content = " + var17_42);
                                        }
                                    }
                                } else {
                                    Vector<Byte> vector19 = new Vector<Byte>();
                                    if (this._cpusAllocateForPPAR != null) {
                                        if (this._cpusAllocateForPPAR.contains(new Integer(n6))) {
                                            this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                                            this._cpuReassignment.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            this._cpusToCheck.put(new Byte((byte)n6), new Byte(this._theLPAR));
                                            System.out.println("not set atLeastOneCpu = true 8");
                                        }
                                    } else {
                                        vector19.add(new Byte((byte)n6));
                                        hashtable2.put((Serializable)object, vector19);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("content = " + vector19);
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        int n13;
                        vector4.setElementAt(null, n6);
                        if (this._cpusAllocateForPPAR != null) {
                            this._cpusAllocateForPPAR.removeElement(new Integer(n6));
                        }
                        n10 = (Integer)vector3.get(n6);
                        Trace.trace("appahscF", "procState = " + n10);
                        System.out.println("procState: " + n10);
                        if (n10 == 7 && ((n13 = ((Integer)(hashtable = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray = new String[]{Integer.toHexString(n6)}, this._socket, this._cspVersion)).get("PROC_STATUS")).intValue()) == 1 || n13 == 3)) {
                            System.out.println("Found a lost processor!");
                            vector6.add(new Integer(n6));
                            System.out.println("lostProcessors: " + vector6);
                        }
                    }
                }
                --n6;
            }
            vector = (Vector)hashtable2.get(new Byte(this._theLPAR));
            Trace.trace("appahscF", "cpus = " + vector);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("cpus = " + vector);
            }
            Vector vector20 = this._procSequence;
            Trace.trace("appahscF", "free Cpus = " + vector20);
            Trace.trace("appahscF", "_procSequence = " + this._procSequence);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("freeCpus = " + vector20);
            }
            int n14 = 0;
            int n15 = 0;
            if (vector20 != null) {
                n14 = vector20.size();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("numFreeCPUs = " + n14);
                }
            }
            if (vector != null) {
                n15 = vector.size();
                try {
                    if (this._procIDForUpdateMemory == -1) {
                        this._procIDForUpdateMemory = ((Byte)vector.elementAt(n15 - 1)).intValue();
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("numCPUOwn = " + n15);
                }
            }
            if (!this._isPhysicalPartition) {
                if (n15 == n2 && n15 >= n) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Byte by = (Byte)enumeration.nextElement();
                        this._cpusToCheck.put(by, new Byte(this._theLPAR));
                        if (this._procIDForUpdateMemory != -1) continue;
                        this._procIDForUpdateMemory = by.intValue();
                    }
                    return;
                }
                if (n15 < n2) {
                    if (n15 != 0) {
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Byte by = (Byte)enumeration.nextElement();
                            this._cpusToCheck.put(by, new Byte(this._theLPAR));
                            if (this._procIDForUpdateMemory != -1) continue;
                            this._procIDForUpdateMemory = by.intValue();
                        }
                    }
                    if (n14 >= n2 - n15) {
                        void var17_50;
                        boolean bl2 = false;
                        while (var17_50 < n2 - n15) {
                            Byte by = (Byte)this._procSequence.elementAt(0);
                            this._procSequence.removeElementAt(0);
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("cpuID = " + by);
                            }
                            this._cpuReassignment.put(by, new Byte(this._theLPAR));
                            this._cpusToCheck.put(by, new Byte(this._theLPAR));
                            if (this._procIDForUpdateMemory == -1) {
                                this._procIDForUpdateMemory = by.intValue();
                            }
                            ++var17_50;
                        }
                        return;
                    }
                    if (n14 != 0) {
                        void var17_52;
                        boolean bl3 = false;
                        while (var17_52 < n14) {
                            Byte by = (Byte)this._procSequence.elementAt(0);
                            this._procSequence.removeElementAt(0);
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("cpuID = " + by);
                            }
                            this._cpuReassignment.put(by, new Byte(this._theLPAR));
                            this._cpusToCheck.put(by, new Byte(this._theLPAR));
                            if (this._procIDForUpdateMemory == -1) {
                                this._procIDForUpdateMemory = by.intValue();
                            }
                            ++var17_52;
                        }
                    }
                    hashtable2.remove(new Byte(this._theLPAR));
                    hashtable2.remove(new Byte(0));
                    n15 += n14;
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("numCPUOwn = " + n15);
                    }
                    int n16 = this.stealCPU(n15, n, n2, hashtable2);
                    hashtable = HscProviderUtils.getCapabilities(this._cspVersion, this._socket);
                    int n17 = (Integer)hashtable.get("RuntimeCapability");
                    if (n16 == -1) return;
                    if ((n17 & 0x10) != 16 || !HscProviderUtils.checkPermission(new HscPermission("dlpar", HscPermission.HSC_ACTION_RESTORE), null)) throw new HSCCIMException("03EA", new String[]{String.valueOf(n16), String.valueOf(n)});
                    System.out.println("looking at lost processors...");
                    n4 = n - n16;
                    System.out.println("number needed: " + n4);
                    System.out.println("lost procs: " + vector6.size());
                    if (n4 > vector6.size()) throw new HSCCIMException("03EA", new String[]{String.valueOf(n16), String.valueOf(n)});
                    throw new HSCCIMException("290F");
                }
                int n18 = n15 - n2;
                n5 = 0;
                while (n5 < n18) {
                    Byte by = (Byte)vector.elementAt(0);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("cpuID = " + by);
                    }
                    vector.removeElementAt(0);
                    this._cpuReassignment.put(by, new Byte(0));
                    this._cpusToCheck.put(by, new Byte(0));
                    ++n5;
                }
                int n19 = 0;
                while (n19 < n2) {
                    Byte by = (Byte)vector.elementAt(n19);
                    this._cpusToCheck.put(by, new Byte(this._theLPAR));
                    ++n19;
                }
                return;
            }
            if (n15 != 0) {
                boolean bl4 = false;
                n5 = 0;
                while (n5 < n15) {
                    n4 = ((Byte)vector.elementAt(n5)).byteValue();
                    if (this._cpusAllocateForPPAR.contains(new Integer(n4))) {
                        this._cpusToCheck.put(new Byte((byte)n4), new Byte(this._theLPAR));
                        this._cpusAllocateForPPAR.removeElement(new Integer(n4));
                        e = vector4.elementAt(n4);
                        if (e != null && ((n3 = ((Integer)e).intValue()) == 1 || n3 == 3)) {
                            if (!bl4) {
                                this._procIDForUpdateMemory = n4;
                            }
                            bl = true;
                            System.out.println("atLeastOneCpu = true 9");
                        }
                    } else {
                        this._cpuReassignment.put(new Byte((byte)n4), new Byte(0));
                        this._cpusToCheck.put(new Byte((byte)n4), new Byte(0));
                    }
                    ++n5;
                }
            }
            if (this._cpusAllocateForPPAR != null && this._cpusAllocateForPPAR.size() != 0) {
                void var17_57;
                boolean bl5 = false;
                while (var17_57 < this._cpusAllocateForPPAR.size()) {
                    n5 = (byte)((Integer)this._cpusAllocateForPPAR.elementAt((int)var17_57)).intValue();
                    this._cpuReassignment.put(new Byte((byte)n5), new Byte(this._theLPAR));
                    this._cpusToCheck.put(new Byte((byte)n5), new Byte(this._theLPAR));
                    Byte by = (Byte)this._cpuAssignment.get(new Byte((byte)n5));
                    if (this._lparDefState[by.intValue() - 1] == 10) {
                        this._lparDefState[by.intValue() - 1] = 11;
                        this._invalidLPARs.add(by);
                    }
                    if ((e = vector4.elementAt(n5)) != null && ((n3 = ((Integer)e).intValue()) == 1 || n3 == 3)) {
                        if (this._procIDForUpdateMemory == -1) {
                            this._procIDForUpdateMemory = n5;
                        }
                        bl = true;
                        System.out.println("atLeastOneCpu = true 10");
                    }
                    ++var17_57;
                }
            }
            if (bl) return;
            throw new HSCCIMException("03EA", new String[]{String.valueOf(0), String.valueOf(1)});
        }
        finally {
            Trace.trace("appahscT", "<- allocateCPU");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of allocateCPU");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stealCPU(int n, int n2, int n3, Hashtable hashtable) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In stealCPU");
        }
        Trace.trace("appahscT", "-> stealCPU");
        Trace.trace("appahscF", "ownAmount = " + n);
        Trace.trace("appahscF", "requiredAmount = " + n2);
        Trace.trace("appahscF", "desiredAmount = " + n3);
        Trace.trace("appahscF", "cpuAssigned = " + hashtable);
        Enumeration enumeration = this._cpuReassignment.keys();
        try {
            Object[] objectArray;
            Enumeration enumeration2 = hashtable.keys();
            Vector<Object[]> vector = new Vector<Object[]>();
            while (enumeration2.hasMoreElements()) {
                Byte by = (Byte)enumeration2.nextElement();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("lparID = " + by);
                }
                Trace.trace("appahscD", "lparID = " + by);
                Vector vector2 = (Vector)hashtable.get(by);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("cpus = " + vector2);
                }
                Trace.trace("appahscF", "cpus = " + vector2);
                objectArray = new Object[]{by, vector2};
                if (vector2.size() == n3 - n) {
                    int n4 = vector2.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        this._cpuReassignment.put(vector2.get(n5), new Byte(this._theLPAR));
                        this._cpusToCheck.put(vector2.get(n5), new Byte(this._theLPAR));
                        ++n5;
                    }
                    if (this._lparDefState[by.intValue() - 1] == 10) {
                        this._lparDefState[by.intValue() - 1] = 11;
                        this._invalidLPARs.add(by);
                    }
                    int n6 = -1;
                    return n6;
                }
                vector.add(objectArray);
            }
            Collections.sort(vector, new CPUComparator());
            while (!vector.isEmpty()) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("sortedList is not empty");
                }
                int n7 = vector.size();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("length = " + n7);
                }
                int n8 = 0;
                while (n8 < n7) {
                    int n9;
                    objectArray = (Object[])vector.get(n8);
                    Byte by = (Byte)objectArray[0];
                    Trace.trace("appahscF", "lparID = " + by);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("lparID = " + by);
                    }
                    Vector vector3 = (Vector)objectArray[1];
                    Trace.trace("appahscF", "cpus = " + vector3);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("cpus = " + vector3);
                    }
                    int n10 = vector3.size();
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("numCPUs = " + n10);
                    }
                    if (n10 == n3 - n) {
                        n9 = 0;
                        while (n9 < n10) {
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("cpus[" + n9 + "] = " + vector3.get(n9));
                            }
                            this._cpuReassignment.put(vector3.get(n9), new Byte(this._theLPAR));
                            this._cpusToCheck.put(vector3.get(n9), new Byte(this._theLPAR));
                            ++n9;
                        }
                        if (this._lparDefState[by.intValue() - 1] == 10) {
                            this._lparDefState[by.intValue() - 1] = 11;
                            this._invalidLPARs.add(by);
                        }
                        int n11 = -1;
                        return n11;
                    }
                    if (n10 < n3 - n) {
                        if (n8 == n7 - 1) {
                            n9 = 0;
                            while (n9 < n10) {
                                this._cpuReassignment.put(vector3.get(n9), new Byte(this._theLPAR));
                                this._cpusToCheck.put(vector3.get(n9), new Byte(this._theLPAR));
                                ++n9;
                            }
                            vector.removeElementAt(n8);
                            n += n10;
                            if (this._lparDefState[by.intValue() - 1] == 10) {
                                this._lparDefState[by.intValue() - 1] = 11;
                                this._invalidLPARs.add(by);
                            }
                        }
                    } else {
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("desiredAmount = " + n3);
                            System.out.println("ownAmount = " + n);
                        }
                        n9 = 0;
                        while (n9 < n3 - n) {
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("cpus[" + n9 + "] = " + vector3.get(n9));
                            }
                            this._cpuReassignment.put(vector3.get(n9), new Byte(this._theLPAR));
                            this._cpusToCheck.put(vector3.get(n9), new Byte(this._theLPAR));
                            ++n9;
                        }
                        if (this._lparDefState[by.intValue() - 1] == 10) {
                            this._lparDefState[by.intValue() - 1] = 11;
                            this._invalidLPARs.add(by);
                        }
                        int n12 = -1;
                        return n12;
                    }
                    ++n8;
                }
            }
            if (n >= n2) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("ownAmount >= requiredAmount");
                }
                int n13 = -1;
                return n13;
            }
            int n14 = n;
            return n14;
        }
        finally {
            Trace.trace("appahscT", "<- stealCPU");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of stealCPU");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    public void allocateMemory(long l, long l2, long l3) throws CIMException {
        System.out.println("IN ALLOCATE MEMORY!!!");
        Trace.trace("appahscT", "-> allocateMemory");
        Trace.trace("appahscF", "requiredAmount = " + l);
        Trace.trace("appahscF", "desiredAmount = " + l2);
        System.out.println("required mem: " + l);
        System.out.println("desired mem: " + l2);
        System.out.print("max amount: " + l3);
        try {
            Hashtable hashtable = null;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            long l9 = 0L;
            long l10 = 0L;
            int n = 0;
            long l11 = 0L;
            hashtable = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, this._socket, this._cspVersion);
            l6 = (Long)hashtable.get("REGION_SIZE");
            Trace.trace("appahscF", "regionSize = " + l6);
            n = (Integer)hashtable.get("PAGE_TABLE_RATIO");
            System.out.println("mem to page table ratio: " + n);
            Trace.trace("appahscF", "memPTRatio = " + String.valueOf(n));
            l7 = (Long)hashtable.get("TOT_AVAILABLE_MEMORY");
            Trace.trace("appahscF", "availableMem = " + String.valueOf(l7));
            System.out.println("Total available mem. in system: " + l7);
            if (this._cspMappedVer >= 3000) {
                l8 = (Long)hashtable.get("MEMORY_INSTALLED");
                l9 = (Long)hashtable.get("HYPER_ALLOC_MEMORY");
                l10 = (Long)hashtable.get("FAILED_MEMORY");
                Trace.trace("appahscF", "cecInstMem = " + l8 + " hyperMem = " + l9 + " failedMem = " + l10);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("     cecInstMem = " + l8 + " hyperMem = " + l9 + " failedMem = " + l10);
                }
                l11 = this.pageTableSize(l3, l6, n);
                System.out.println("max amt. pagetable size: " + l11);
                if (l3 + l11 > l8 - l9 - l10) {
                    throw new HSCCIMException("059A", new String[]{Long.toString(l3)});
                }
            }
            l5 = this._cspMappedVer < 3000 ? this.pageTableSize(l2, l6, n) : l11;
            System.out.println("Page table mem. needed: " + l5);
            long l12 = l2 + l5;
            System.out.println("maxMemNeeded: " + l12);
            Trace.trace("appahscF", "maxMemNeeded = " + String.valueOf(l12));
            Hashtable hashtable2 = this.getFreeMemory(l7, l6, n);
            long l13 = (Long)hashtable2.get("freeMem");
            long l14 = (Long)hashtable2.get("recovMem");
            Vector vector = (Vector)hashtable2.get("stealList");
            System.out.println("Now, free mem: " + l13);
            if (l13 >= l12) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("     freeMem is greater than or equal to maxMemNeeded");
                }
                this._memoryAssigned = l2;
                System.out.println("memoryAssigned: " + this._memoryAssigned);
                return;
            }
            long l15 = this.stealMemory((int)l13, l, l2, l12, vector, l6, n, l11, l3);
            System.out.println("Stole memory! return val = " + l15);
            if (l15 != -1L) {
                hashtable = HscProviderUtils.getCapabilities(this._cspVersion, this._socket);
                int n2 = (Integer)hashtable.get("RuntimeCapability");
                if (this._cspMappedVer >= 3000) {
                    System.out.println("Again, max amt. page table size: " + l11);
                    long l16 = l + l11;
                    if ((n2 & 0x10) == 16 && HscProviderUtils.checkPermission(new HscPermission("dlpar", HscPermission.HSC_ACTION_RESTORE), null)) {
                        long l17 = l16 - l15;
                        System.out.println("amount needed: " + l17);
                        System.out.println("recoverableMem: " + l14);
                        if (l14 >= l17) {
                            throw new HSCCIMException("2911");
                        }
                        System.out.println("still not enough memory!");
                        throw new HSCCIMException("03EC", new String[]{this.convertMem(l15), this.convertMem(l16)});
                    }
                    throw new HSCCIMException("03EC", new String[]{this.convertMem(l15), this.convertMem(l16)});
                }
                long l18 = this.pageTableSize(l, l6, n);
                throw new HSCCIMException("03EC", new String[]{this.convertMem(l15), this.convertMem(l + l18)});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("05E9");
            }
            throw (HSCCIMException)((Object)throwable);
        }
        finally {
            Trace.trace("appahscT", "<- allocateMemory");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of allocateMemory");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stealMemory(long l, long l2, long l3, long l4, Vector vector, long l5, int n, long l6, long l7) throws CIMException {
        Trace.trace("appahscT", "-> stealMemory");
        Trace.trace("appahscF", "ownAmount = " + l);
        Trace.trace("appahscF", "requiredAmount = " + l2);
        Trace.trace("appahscF", "desiredAmount = " + l3);
        Trace.trace("appahscF", "maxMemNeeded = " + l4);
        Trace.trace("appahscF", "lparMemPairList = " + vector);
        Trace.trace("appahscF", "regionSize = " + l5);
        Trace.trace("appahscF", "memPTRatio = " + n);
        Hashtable hashtable = new Hashtable();
        try {
            long l8 = this._sortAndSteal(l, l3, l4, vector);
            if (l8 == -1L) {
                long l9 = -1L;
                return l9;
            }
            long l10 = 0L;
            long l11 = 0L;
            if (this._cspMappedVer >= 3000) {
                l10 = l6;
                l11 = this.roundToPowerOf2(l7 / (long)n);
            } else {
                l10 = this.pageTableSize(l2, l5, n);
                l11 = this.roundToPowerOf2(l2 / (long)n);
            }
            System.out.println("page table size = " + l10);
            System.out.println("see if amountToCheck < regionSize/2 ");
            if (l11 <= l5 / 2L) {
                if (l8 < l2) {
                    long l12 = l8;
                    return l12;
                }
                if (l8 == l2) {
                    System.out.println("accumulatedMem == requiredAmount and small page table. Gambling.");
                    this._memoryAssigned = l2;
                    long l13 = -1L;
                    return l13;
                }
            } else {
                System.out.println("amountToCheck > regionSize/2");
                if (l8 < l2 + l10) {
                    long l14 = l8;
                    return l14;
                }
            }
            if (l8 == l2 + l10) {
                this._memoryAssigned = l2;
                long l15 = -1L;
                return l15;
            }
            this._memoryAssigned = this._cspMappedVer >= 3000 ? l8 - l10 : this.memPortionSize(l8, l5, n);
            Trace.trace("appahscF", "_memoryAssigned = " + String.valueOf(this._memoryAssigned));
            long l16 = -1L;
            return l16;
        }
        finally {
            Trace.trace("appahscT", "<- StealMemory");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of stealMemory");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    public Hashtable stealMemForDLPAR(long l, long l2, long l3, Vector vector) throws CIMException {
        System.out.println("In stealMemForDLPAR..");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        long l4 = this._sortAndSteal(l, l2, l3, vector);
        if (l4 == -1L) {
            System.out.println("stealing successful!");
            hashtable.put("memAmt", new Long(-1L));
        } else if (l4 < l3) {
            hashtable.put("memAmt", new Long(l4));
        } else {
            hashtable.put("memAmt", new Long(-1L));
            System.out.println("Success!");
            System.out.println("needed: " + l3);
            System.out.println("found: " + l4);
        }
        Byte[] byteArray = this._invalidLPARs.toArray(new Byte[0]);
        hashtable.put("invalidLpars", byteArray);
        return hashtable;
    }

    private Hashtable getAdapterInfo(String string) throws Exception {
        String[] stringArray = new String[]{string};
        return HscProviderUtils.doCSPCommand("GET_SMA_ADAPTER_INFO", stringArray, this._socket, this._cspVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void allocateSMA(int n, Vector vector, Vector vector2) throws CIMException {
        block17: {
            block16: {
                Trace.trace("appahscT", "-> allocateSMA");
                try {
                    try {
                        String[] stringArray = new String[1];
                        String string = null;
                        int n2 = 0;
                        this._smaDeviceIDs = new Vector();
                        this._smaWindowSizes = new Vector();
                        this._smaLPARIDs = new Vector();
                        this._smaLPARDeviceIDs = new Vector();
                        if (n == 0) {
                            System.out.println("No SMA adapters requested!");
                            Object var17_9 = null;
                            break block16;
                        }
                        if (vector.size() % 2 != 0) {
                            System.out.println("Odd number of adapters sent down!");
                            throw new HSCCIMException("3304");
                        }
                        System.out.println("number of adapter groups: " + vector.size() / 2);
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String string2 = null;
                        int n3 = 0;
                        while (true) {
                            Object object;
                            if (n3 >= vector.size()) {
                                this.checkPreAllocatedAdapters(vector);
                                System.out.println("good device ID's: " + this._smaDeviceIDs);
                                System.out.println("and their windows: " + this._smaWindowSizes);
                                break block17;
                            }
                            string = (String)vector.elementAt(n3);
                            n2 = ((UnsignedInt16)vector2.elementAt(n3)).intValue();
                            if (n3 % 2 == 0) {
                                bl2 = false;
                                string2 = null;
                            }
                            string2 = string2 == null ? string : string2 + " / " + string;
                            System.out.println("Device ID: " + string);
                            System.out.println("num. of windows: " + n2);
                            Trace.trace("appahscD", "SMA Device id wanted : " + string);
                            Trace.trace("appahscD", "Number of windows wanted : " + n2);
                            Hashtable hashtable = this.getAdapterInfo(string);
                            short s = ((Integer)hashtable.get("SMA_STATUS")).shortValue();
                            System.out.println("The SMA status is :" + s);
                            short s2 = ((Integer)hashtable.get("SMA_STATE")).shortValue();
                            System.out.println("The SMA state is :" + s2);
                            if (s == 1 && s2 == 8) {
                                this.validateSMAAdapter(hashtable, n, string, n2);
                                bl2 = true;
                            } else if (s == 0) {
                                bl3 = true;
                            }
                            if (n3 % 2 == 1 && !bl2) {
                                System.out.println("Neither adapter in pair was good!");
                                object = "3303";
                                if (!bl3) throw new HSCCIMException((String)object, new String[]{string2});
                                object = "3305";
                                throw new HSCCIMException((String)object, new String[]{string2});
                            }
                            object = (Vector)hashtable.get("LPAR_INFO_LIST");
                            this.stealSma((Vector)object, string, this._theLPAR);
                            ++n3;
                        }
                    }
                    catch (HSCCIMException hSCCIMException) {
                        hSCCIMException.printStackTrace();
                        throw hSCCIMException;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new HSCCIMException("05E9");
                    }
                }
                catch (Throwable throwable) {
                    Object var17_11 = null;
                    Trace.trace("appahscT", "<- allocateSMA");
                    throw throwable;
                }
            }
            Trace.trace("appahscT", "<- allocateSMA");
            return;
        }
        Object var17_10 = null;
        Trace.trace("appahscT", "<- allocateSMA");
    }

    private void validateSMAAdapter(Hashtable hashtable, int n, String string, int n2) throws Exception {
        int n3 = (Integer)hashtable.get("NUM_WINS_ACTIVE");
        Trace.trace("appahscD", "Number of windows active :" + n3);
        System.out.println("The number of windows active is :" + n3);
        int n4 = (Integer)hashtable.get("NUM_LPARS_ACTIVE");
        Trace.trace("appahscD", "Number of Lpars active :" + n4);
        System.out.println("The number of Lpars active is :" + n4);
        int n5 = (Integer)hashtable.get("MAX_WINS_SUPPORTED");
        System.out.println("Max windows supported :" + n5);
        int n6 = (Integer)hashtable.get("MAX_NUMBER_LPARS");
        System.out.println("Max Lpar supported :" + n6);
        this._smaDeviceIDs.addElement(string);
        if (n == 1) {
            if (n4 != 0 || n3 != 0) {
                throw new HSCCIMException("3300", new String[]{this._lparUserDefName, string});
            }
            this._smaWindowSizes.addElement(new Integer(n5));
        }
        if (n == 2) {
            if (n4 >= n6) {
                throw new HSCCIMException("3301", new String[]{this._lparUserDefName, string});
            }
            if (n3 + n2 > n5) {
                String string2 = Integer.toString(n2);
                String string3 = Integer.toString(n5 - n3);
                throw new HSCCIMException("3302", new String[]{this._lparUserDefName, string, string2, string3});
            }
            this._smaWindowSizes.addElement(new Integer(n2));
        }
    }

    private void checkPreAllocatedAdapters(Vector vector) throws Exception {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_NUMBER_OF_SMA_ADAPTERS", null, this._socket, this._cspVersion);
        Integer n = (Integer)hashtable.get("NUM_OF_ADAPTERS");
        short s = n.shortValue();
        System.out.println("num of SMA: " + s);
        Vector vector2 = (Vector)hashtable.get("DEV_LIST");
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string = ((Long)vector2.elementAt(n2)).toString();
            if (vector.indexOf(string) == -1) {
                this._smaLPARDeviceIDs.addElement(string);
                this._smaLPARIDs.addElement(new Byte(this._theLPAR));
            }
            ++n2;
        }
    }

    public void stealSma(Vector vector, String string, int n) throws CIMException {
        System.out.println("In the stealing of SMA resources @@@@@@@@@@@@@@@@@@@");
        Trace.trace("appahscT", "->stealSma");
        Hashtable hashtable = null;
        try {
            try {
                if (this._lparDefState == null) {
                    this.buildLPARStateTable();
                }
                int n2 = 0;
                while (n2 < vector.size()) {
                    hashtable = (Hashtable)vector.elementAt(n2);
                    byte by = ((Integer)hashtable.get("LPAR_ID")).byteValue();
                    System.out.println("The lpar ID is :" + by);
                    Trace.trace("appahscF", "LPAR id = " + by);
                    int n3 = (Integer)hashtable.get("NUM_WINS_USING");
                    System.out.println("The number of allocated window :" + n3);
                    Trace.trace("appahscF", "The numbe of allocated windows : " + n3);
                    if (n3 > 0) {
                        System.out.println("In the if statement of the stealing");
                        System.out.println("The lpar state value is :" + this._lparDefState[by - 1]);
                        System.out.println("The lpar operational value is :" + this._lparOpState[by - 1]);
                        if (by != n && this._lparDefState[by - 1] == 10 && (this._lparOpState[by - 1] == 1 || this._lparOpState[by - 1] == 12)) {
                            System.out.println("Adding the steal SMA id & partition id");
                            this._smaLPARDeviceIDs.addElement(string);
                            this._smaLPARIDs.addElement(new Byte(by));
                            Trace.trace("appahscF", "Adding SMA id to _smaLPARDeviceIDs vector : " + string);
                            Trace.trace("appahscF", "Adding LPAR id to _smaLPARIDs vector : " + by);
                            if (!this._invalidLPARs.contains(new Byte(by))) {
                                this._invalidLPARs.add(new Byte(by));
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new HSCCIMException("05E9");
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Trace.trace("appahscT", "<- stealSma");
            throw throwable;
        }
        Trace.trace("appahscT", "<- stealSma");
    }

    public long roundToPowerOf2(long l) {
        long l2;
        long l3 = l;
        int n = 0;
        if (l > 0x4000000000000000L || l < 0L) {
            return -1L;
        }
        if (l == 0L) {
            return 1L;
        }
        if ((l3 & 0xFFFFFFFF00000000L) > 0L) {
            l3 >>>= 32;
            n += 32;
        }
        if ((l3 & 0xFFFFFFFFFFFF0000L) > 0L) {
            l3 >>>= 16;
            n += 16;
        }
        if ((l3 & 0xFFFFFFFFFFFFFF00L) > 0L) {
            l3 >>>= 8;
            n += 8;
        }
        if ((l3 & 0xFFFFFFFFFFFFFFF0L) > 0L) {
            l3 >>>= 4;
            n += 4;
        }
        if ((l3 & 0xFFFFFFFFFFFFFFFCL) > 0L) {
            l3 >>>= 2;
            n += 2;
        }
        if ((l3 & 0xFFFFFFFFFFFFFFFEL) > 0L) {
            ++n;
        }
        if (l > (l2 = 1L << n)) {
            return l2 << 1;
        }
        return l;
    }

    public long pageTableSize(long l, long l2, int n) {
        long l3 = 0L;
        long l4 = 0L;
        Trace.trace("appahscT", "-> pageTableSize");
        l4 = this.roundToPowerOf2(l / (long)n);
        l3 = (long)(Math.ceil((double)l4 / (double)l2) * (double)l2);
        System.out.println("In Activator.pageTableSize, PageTable=" + l4 + " memForPageTable=" + l3);
        Trace.trace("appahscT", "<- pageTableSize");
        return l3;
    }

    public long memPortionSize(long l, long l2, int n) {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        Trace.trace("appahscT", "-> memPortionSize");
        l3 = this.pageTableSize(l, l2, n);
        l4 = l - l3;
        System.out.println("In Activator.memPortionSize. First Estimation-- memoryAmount=" + l + " estimatedPtSize=" + l3 + " estimatedMemSize=" + l4);
        l5 = this.pageTableSize(l4, l2, n);
        if (l5 != l3) {
            l3 = l5;
            l4 = Math.min(l - l3, l3 * (long)n);
        }
        System.out.println("In Activator.memPortionSize. Final Estimation-- memoryAmount=" + l + " estimatedPtSize=" + l3 + " estimatedMemSize=" + l4);
        Trace.trace("appahscT", "<- memPortionSize");
        return l4;
    }

    public String convertMem(long l) {
        String string = "";
        long l2 = 0L;
        string = l == 0L ? "0 MB" : ((l2 = l / 1024L) == 0L ? l + " MB" : l2 + " GB " + l % 1024L + " MB");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCSPResources() throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In setCSPResources");
        }
        Trace.trace("appahscT", "-> setCSPResources");
        try {
            String string;
            Object object;
            byte by;
            int n;
            int n2;
            Serializable serializable;
            Enumeration enumeration;
            String[] stringArray;
            if (this._theLPARDefState == 10) {
                stringArray = new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(11)};
                HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, this._socket, this._cspVersion);
                System.out.println("INVALIDATED! setCSPResources1");
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("##### after call setInstance internal");
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("before checking invalid lpars");
            }
            Trace.trace("appahscF", "_invalidLPARs = " + this._invalidLPARs);
            Enumeration<Object> enumeration2 = this._invalidLPARs.elements();
            while (enumeration2.hasMoreElements()) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("has invalid lpars");
                }
                enumeration = (Byte)enumeration2.nextElement();
                stringArray = new String[]{Integer.toHexString(((Byte)((Object)enumeration)).byteValue()), Integer.toHexString(11)};
                HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, this._socket, this._cspVersion);
                System.out.println("INVALIDATED! Resources have been stolen");
                if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                System.out.println("##### after call setInstance internal");
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("before checking free ios");
            }
            enumeration2 = this._ioFree.keys();
            while (enumeration2.hasMoreElements()) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("has I/O slots need to be freed");
                }
                enumeration = (String)enumeration2.nextElement();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("drawerID = " + (String)((Object)enumeration));
                }
                Trace.trace("appahscF", "drawerID = " + (String)((Object)enumeration));
                serializable = (Vector)this._ioFree.get(enumeration);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("freeSlots = " + serializable);
                }
                Trace.trace("appahscF", "freeSlots = " + serializable);
                n2 = ((Vector)serializable).size();
                n = 0;
                while (n < n2) {
                    by = (Byte)((Vector)serializable).get(n);
                    Trace.trace("appahscD", "slotID = " + by);
                    stringArray = new String[]{enumeration, Integer.toHexString(by), Integer.toHexString(0)};
                    HscProviderUtils.doCSPCommand("SET_IO_SLOT_LPAR_ASSIGN_VALUE", stringArray, this._socket, this._cspVersion);
                    try {
                        object = new String[]{enumeration, String.valueOf(by), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(this._theLPAR)};
                        string = "Drawer ID " + object[0] + " slot " + object[1] + " of CEC " + object[2] + " with ID of " + object[3] + " has been freed from LPAR " + object[4] + " with ID " + object[5];
                        HSCLogUtils.logSystemEvent((short)2022, string, object, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                    ++n;
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("before checking reassigned io");
            }
            enumeration2 = this._ioReassignment.keys();
            while (enumeration2.hasMoreElements()) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("has I/O slots need to be reassigned");
                }
                enumeration = (String)enumeration2.nextElement();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("drawerID = " + (String)((Object)enumeration));
                }
                Trace.trace("appahscF", "drawerID = " + (String)((Object)enumeration));
                serializable = (Vector)this._ioReassignment.get(enumeration);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("reassignSlots = " + serializable);
                }
                n2 = ((Vector)serializable).size();
                n = 0;
                while (n < n2) {
                    by = (Byte)((Vector)serializable).get(n);
                    Trace.trace("appahscD", "slotID = " + by);
                    stringArray = new String[]{enumeration, Integer.toHexString(by), Integer.toHexString(this._theLPAR)};
                    HscProviderUtils.doCSPCommand("SET_IO_SLOT_LPAR_ASSIGN_VALUE", stringArray, this._socket, this._cspVersion);
                    try {
                        object = new String[]{enumeration, String.valueOf(by), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(this._theLPAR)};
                        string = "Drawer ID " + object[0] + " slot " + object[1] + " of CEC " + object[2] + " with ID of " + object[3] + " has been assigned to LPAR " + object[4] + " with ID " + object[5];
                        HSCLogUtils.logSystemEvent((short)2023, string, object, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                    ++n;
                }
            }
            if (this._cspMappedVer >= 4000) {
                Trace.trace("appahscF", "In set SMA resources");
                Trace.trace("appahscF", "_smaDeviceIDs = " + this._smaDeviceIDs);
                Trace.trace("appahscF", "_smaWindowSize = " + this._smaWindowSizes);
                System.out.println("In setCSPResources freeing SMA resources");
                enumeration2 = this._smaLPARDeviceIDs.elements();
                enumeration = this._smaLPARIDs.elements();
                serializable = new Integer(0);
                while (enumeration2.hasMoreElements()) {
                    System.out.println("In the setting of the freeing SMA resources loop");
                    String string2 = (String)enumeration2.nextElement();
                    Byte by2 = (Byte)enumeration.nextElement();
                    Trace.trace("appahscF", "SMA ID to free = " + string2);
                    Trace.trace("appahscF", "LPAR id to free sma= " + by2);
                    stringArray = new String[]{string2, Integer.toHexString(by2.byteValue()), Integer.toHexString(0), ((Integer)serializable).toString(), ((Integer)serializable).toString()};
                    HscProviderUtils.doCSPCommand("SET_SMA_LPAR_VALUE", stringArray, this._socket, this._cspVersion);
                    try {
                        String[] stringArray2 = new String[]{string2, String.valueOf(serializable), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(by2)};
                        object = "SNI ID " + stringArray2[0] + " window size " + stringArray2[1] + " of CEC " + stringArray2[2] + " with ID of " + stringArray2[3] + " has been freed from LPAR " + stringArray2[4] + " with ID " + stringArray2[5];
                        HSCLogUtils.logSystemEvent((short)2165, (String)object, stringArray2, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                }
                System.out.println("Setting the SMA resources for the partition");
                System.out.println("The LPAR value is :" + this._theLPAR);
                enumeration2 = this._smaDeviceIDs.elements();
                enumeration = this._smaWindowSizes.elements();
                while (enumeration2.hasMoreElements()) {
                    System.out.println("In the setting of the SMA resources for the partition loop");
                    String string3 = (String)enumeration2.nextElement();
                    Integer n3 = (Integer)enumeration.nextElement();
                    Trace.trace("appahscF", "smaID to allocate = " + string3);
                    Trace.trace("appahscF", "window size to allocate = " + n3);
                    System.out.println("The smaID is:" + string3);
                    System.out.println("The window size is:" + n3);
                    stringArray = new String[]{string3, Integer.toHexString(this._theLPAR), Integer.toHexString(1), n3.toString(), n3.toString()};
                    HscProviderUtils.doCSPCommand("SET_SMA_LPAR_VALUE", stringArray, this._socket, this._cspVersion);
                    try {
                        String[] stringArray3 = new String[]{string3, String.valueOf(n3), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(this._theLPAR)};
                        object = "SNI ID " + stringArray3[0] + "window size  " + stringArray3[1] + " of CEC " + stringArray3[2] + " with ID of " + stringArray3[3] + " has been assigned to LPAR " + stringArray3[4] + " with ID " + stringArray3[5];
                        HSCLogUtils.logSystemEvent((short)2164, (String)object, stringArray3, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("checking reassignment cpu");
            }
            boolean bl = false;
            enumeration2 = this._cpuReassignment.keys();
            while (enumeration2.hasMoreElements()) {
                serializable = (Byte)enumeration2.nextElement();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("cpuID = " + serializable);
                }
                Trace.trace("appahscF", "cpuID = " + serializable);
                n2 = ((Byte)this._cpuReassignment.get(serializable)).byteValue();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("lparID = " + n2);
                }
                Trace.trace("appahscF", "lparID = " + String.valueOf(n2));
                stringArray = new String[]{Integer.toHexString(((Byte)serializable).byteValue()), Integer.toHexString(n2)};
                HscProviderUtils.doCSPCommand("SET_PROC_LPAR_ASSIGN_VALUE", stringArray, this._socket, this._cspVersion);
                try {
                    String string4;
                    String[] stringArray4 = new String[]{String.valueOf(serializable), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(this._theLPAR)};
                    if (n2 == 0) {
                        string4 = "Processor ID " + stringArray4[0] + " of CEC " + stringArray4[1] + " with ID of " + stringArray4[2] + " has been freed from LPAR " + stringArray4[3] + " with ID " + stringArray4[4];
                        HSCLogUtils.logSystemEvent((short)2024, string4, stringArray4, null);
                        continue;
                    }
                    try {
                        if (!bl) {
                            this._procIDForUpdateMemory = ((Byte)serializable).intValue();
                            bl = true;
                        }
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    }
                    string4 = "Processor ID " + stringArray4[0] + " of CEC " + stringArray4[1] + " with ID of " + stringArray4[2] + " has been assigned to LPAR " + stringArray4[3] + " with ID " + stringArray4[4];
                    HSCLogUtils.logSystemEvent((short)2025, string4, stringArray4, null);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("before reassing memory");
            }
            if (this._memoryAssigned != 0L) {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("memoryAssigned = " + this._memoryAssigned);
                }
                Trace.trace("appahscF", "_memoryAssigned = " + this._memoryAssigned);
                System.out.println("_memoryAssigned = " + this._memoryAssigned);
                stringArray = new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(0), Integer.toHexString(0), Integer.toHexString(0), Long.toString(this._memoryAssigned), this._cspMappedVer < 3000 ? Long.toString(this._memoryAssigned) : Long.toString(this._maxMem)};
                HscProviderUtils.doCSPCommand("SET_MEMORY_RESOURCES_FOR_LPAR", stringArray, this._socket, this._cspVersion);
                try {
                    serializable = new String[]{String.valueOf(this._memoryAssigned), this._cecUserDefName, this._cecNameStr, this._lparUserDefName, String.valueOf(this._theLPAR)};
                    String string5 = (String)((Object)serializable[0]) + " of memory from CEC " + (String)((Object)serializable[1]) + " with ID of " + (String)((Object)serializable[2]) + " has been assigned to LPAR " + (String)((Object)serializable[3]) + " with ID " + (String)((Object)serializable[4]);
                    HSCLogUtils.logSystemEvent((short)2026, string5, (String[])serializable, null);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                }
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("no problem in setCSPResource");
            }
            stringArray = new String[]{Integer.toHexString(this._theLPAR), Integer.toHexString(10)};
            HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, this._socket, this._cspVersion);
            return;
        }
        finally {
            Trace.trace("appahscT", "<- setCSPResources");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of setCSPResources");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    public void updateCIMOMCache() {
        block113: {
            Object object;
            Serializable serializable;
            Object object2;
            String string;
            block111: {
                Object object3;
                block110: {
                    block109: {
                        CIMObjectPath cIMObjectPath;
                        CIMObjectPath cIMObjectPath2;
                        Vector vector;
                        Object object4;
                        Object object5;
                        Object object6;
                        block101: {
                            CIMInstance cIMInstance;
                            block100: {
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.print("********************");
                                    System.out.println("********************");
                                    System.out.println("In updateCIMOMCache");
                                }
                                Trace.trace("appahscT", "-> updateCIMOMCache");
                                string = "root/ibmhscV3_2";
                                cIMInstance = null;
                                try {
                                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, new CIMClass(this._partitionOP.getObjectName()), false);
                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                        System.out.println("dLpar = " + cIMInstance);
                                    }
                                    Trace.trace("appahscF", "dLpar = " + cIMInstance);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    if (GlobalConfig.debugLevel((int)2) <= 0) break block100;
                                    System.out.println("LOG: Problem getting the partition instance");
                                }
                            }
                            try {
                                if (cIMInstance != null) {
                                    cIMInstance.setProperty("BootErrorValue", new CIMValue((Object)new UnsignedInt8(0)));
                                    CimomWrapper.setInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, cIMInstance);
                                }
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                if (GlobalConfig.debugLevel((int)2) <= 0) break block101;
                                System.out.println("LOG: problem reset the boot error value instance");
                            }
                        }
                        if (this._cpusToCheck != null && !this._cpusToCheck.isEmpty()) {
                            CIMObjectPath cIMObjectPath3;
                            block102: {
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("_cpuReassignement != empty");
                                }
                                object3 = this._cpusToCheck.keys();
                                object2 = null;
                                serializable = null;
                                cIMObjectPath3 = null;
                                Object var7_17 = null;
                                object = new CIMObjectPath("IBMHSC_AllocatedProcessor", string);
                                object6 = null;
                                try {
                                    object6 = this._cimomHandle.getClass(object, false);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    if (GlobalConfig.debugLevel((int)2) <= 0) break block102;
                                    System.out.println("LOG: problem to get allocatedCPU class");
                                }
                            }
                            object5 = null;
                            object4 = null;
                            if (object6 != null) {
                                while (object3.hasMoreElements()) {
                                    block104: {
                                        block103: {
                                            object2 = (Byte)object3.nextElement();
                                            serializable = (Byte)this._cpusToCheck.get(object2);
                                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                                System.out.println("cpu = " + object2);
                                                System.out.println("cpuLpar = " + serializable);
                                            }
                                            cIMObjectPath3 = new CIMObjectPath("IBMHSC_Processor", string);
                                            cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)new UnsignedInt8(((Byte)object2).shortValue()), new CIMDataType(1)));
                                            cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                                            cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this._cecNameStr));
                                            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
                                            vector = null;
                                            try {
                                                vector = CimomWrapper.referenceNames((CIMOMHandle)this._cimomHandle, new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2"), cIMObjectPath3, null);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) break block103;
                                                System.out.println("LOG: problem getting the allocated processor");
                                            }
                                        }
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("allocCPUVec = " + vector);
                                        }
                                        if (vector == null || vector.size() == 0) {
                                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                                System.out.println("allocCPUVec.size==0");
                                            }
                                            if (((Byte)serializable).intValue() == 0) continue;
                                            object5 = object6.newInstance();
                                            object5.setProperty("GroupComponent", new CIMValue((Object)this._partitionOP));
                                            object5.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
                                            try {
                                                cIMObjectPath2 = new CIMObjectPath("IBMHSC_AllocatedProcessor", string);
                                                cIMObjectPath2.setKeys(object5.getKeyValuePairs());
                                                CimomWrapper.createInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath2, (CIMInstance)object5);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                                                System.out.println("LOG: problem to create the CPU association");
                                            }
                                            continue;
                                        }
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("allocCPUVec.size() != 1");
                                        }
                                        cIMObjectPath2 = vector.elements();
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("allocCPUVecEnum = " + cIMObjectPath2);
                                        }
                                        boolean bl = false;
                                        if (!cIMObjectPath2.hasMoreElements()) continue;
                                        object4 = (CIMObjectPath)cIMObjectPath2.nextElement();
                                        Trace.trace("appahscF", "allocatedCPUPath = " + object4);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("allocatedCPUPath = " + object4);
                                        }
                                        if (object4 != null) {
                                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                                System.out.println("allocatedCPUPath != null");
                                            }
                                            try {
                                                CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)object4);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) break block104;
                                                System.out.println("LOG: problem to delete the associatio with CPU");
                                            }
                                        }
                                    }
                                    if (((Byte)serializable).intValue() == 0) continue;
                                    object5 = object6.newInstance();
                                    object5.setProperty("GroupComponent", new CIMValue((Object)this._partitionOP));
                                    object5.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
                                    try {
                                        cIMObjectPath = new CIMObjectPath("IBMHSC_AllocatedProcessor", string);
                                        cIMObjectPath.setKeys(object5.getKeyValuePairs());
                                        CimomWrapper.createInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath, (CIMInstance)object5);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                        if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                                        System.out.println("LOG: problem to create the CPU association");
                                    }
                                }
                            }
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("after cpu reassignment");
                            System.out.println("_ioFree = " + this._ioFree);
                        }
                        if (this._ioFree != null && !this._ioFree.isEmpty()) {
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("ioFree not empty");
                            }
                            object3 = this._ioFree.keys();
                            while (object3.hasMoreElements()) {
                                object2 = (String)object3.nextElement();
                                Trace.trace("appahscF", "drawerID = " + (String)object2);
                                serializable = (Vector)this._ioFree.get(object2);
                                Trace.trace("appahscF", "slots = " + serializable);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("slots = " + serializable);
                                }
                                int n = 0;
                                if (serializable != null) {
                                    n = ((Vector)serializable).size();
                                }
                                int n2 = 0;
                                while (n2 < n) {
                                    block105: {
                                        byte by = (Byte)((Vector)serializable).get(n2);
                                        Trace.trace("appahscD", "slotNum = " + by);
                                        if (GlobalConfig.debugLevel((int)2) > 0) {
                                            System.out.println("slotNum = " + by);
                                        }
                                        object6 = new CIMObjectPath("IBMHSC_PCISlot", string);
                                        object6.addKey("IODrawerDeviceID", new CIMValue(object2));
                                        object6.addKey("SlotID", new CIMValue((Object)new UnsignedInt8((short)by), new CIMDataType(1)));
                                        object6.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                                        object6.addKey("IODrawerSystemName", new CIMValue((Object)this._cecNameStr));
                                        object6.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                                        object5 = null;
                                        try {
                                            object5 = CimomWrapper.referenceNames((CIMOMHandle)this._cimomHandle, new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2"), (CIMObjectPath)object6, null);
                                        }
                                        catch (Throwable throwable) {
                                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                            if (GlobalConfig.debugLevel((int)2) <= 0) break block105;
                                            System.out.println("LOG: problem to get the allocatedslot association");
                                        }
                                    }
                                    if (object5 != null && !((Vector)object5).isEmpty()) {
                                        object4 = ((Vector)object5).elements();
                                        while (object4.hasMoreElements()) {
                                            vector = (CIMObjectPath)object4.nextElement();
                                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                                System.out.println("allocSlotOP = " + vector);
                                            }
                                            Trace.trace("appahscD", "allocSlotOP = " + vector);
                                            try {
                                                CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)vector);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                                                System.out.println("LOG: problem delete the allocatedSlot association");
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("after io free");
                        }
                        if (this._ioSlotsToCheck != null && !this._ioSlotsToCheck.isEmpty()) {
                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                System.out.println("ioReassignment is not empty");
                            }
                            object3 = this._ioSlotsToCheck.keys();
                            while (object3.hasMoreElements()) {
                                object2 = (String)object3.nextElement();
                                Trace.trace("appahscF", "drawerID = " + (String)object2);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("drawerID = " + (String)object2);
                                }
                                serializable = (Vector)this._ioSlotsToCheck.get(object2);
                                Trace.trace("appahscF", "slots = " + serializable);
                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                    System.out.println("slots = " + serializable);
                                }
                                int n = ((Vector)serializable).size();
                                int n3 = 0;
                                while (n3 < n) {
                                    block108: {
                                        block107: {
                                            block106: {
                                                byte by = (Byte)((Vector)serializable).get(n3);
                                                Trace.trace("appahscD", "slotNum = " + by);
                                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                                    System.out.println("slotNum = " + by);
                                                }
                                                object6 = new CIMObjectPath("IBMHSC_PCISlot", string);
                                                object6.addKey("IODrawerDeviceID", new CIMValue(object2));
                                                object6.addKey("SlotID", new CIMValue((Object)new UnsignedInt8((short)by), new CIMDataType(1)));
                                                object6.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                                                object6.addKey("IODrawerSystemName", new CIMValue((Object)this._cecNameStr));
                                                object6.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                                                if (GlobalConfig.debugLevel((int)2) > 0) {
                                                    System.out.println("slotOP = " + object6);
                                                }
                                                object5 = null;
                                                try {
                                                    object5 = CimomWrapper.referenceNames((CIMOMHandle)this._cimomHandle, new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2"), (CIMObjectPath)object6, null);
                                                }
                                                catch (Throwable throwable) {
                                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                    if (GlobalConfig.debugLevel((int)2) <= 0) break block106;
                                                    System.out.println("problem getting the allocatedSlot association");
                                                }
                                            }
                                            if (GlobalConfig.debugLevel((int)2) > 0) {
                                                System.out.println("allocSlotVec = " + object5);
                                            }
                                            if (object5 != null && !((Vector)object5).isEmpty()) {
                                                object4 = ((Vector)object5).elements();
                                                while (object4.hasMoreElements()) {
                                                    vector = (CIMObjectPath)object4.nextElement();
                                                    if (GlobalConfig.debugLevel((int)2) > 0) {
                                                        System.out.println("allocSlotOP = " + vector);
                                                    }
                                                    Trace.trace("appahscD", "allocSlotOP = " + vector);
                                                    try {
                                                        CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)vector);
                                                    }
                                                    catch (Throwable throwable) {
                                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                        if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                                                        System.out.println("Log: problem delete the allocatedSlot assoc");
                                                    }
                                                }
                                            }
                                            object4 = null;
                                            try {
                                                object4 = this._cimomHandle.getClass(new CIMObjectPath("IBMHSC_AllocatedSlot", string), false);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) break block107;
                                                System.out.println("LOG: problem getting the AllocatedSlot class");
                                            }
                                        }
                                        if (object4 != null) {
                                            vector = object4.newInstance();
                                            vector.setProperty("GroupComponent", new CIMValue((Object)this._partitionOP));
                                            vector.setProperty("PartComponent", new CIMValue(object6));
                                            try {
                                                cIMObjectPath2 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                                                cIMObjectPath2.setKeys(vector.getKeyValuePairs());
                                                CimomWrapper.createInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath2, (CIMInstance)vector);
                                            }
                                            catch (Throwable throwable) {
                                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                                if (GlobalConfig.debugLevel((int)2) <= 0) break block108;
                                                System.out.println("LOG: problem to create the allocSlot");
                                            }
                                        }
                                    }
                                    ++n3;
                                }
                            }
                        }
                        System.out.println("++++++++++++CIMOM update of SNI allocation in Activator++++++++++");
                        try {
                            System.out.println("++++++++++++++In deleting stolen associations");
                            if (this._smaLPARDeviceIDs == null || this._smaLPARIDs == null) break block109;
                            object3 = this._smaLPARDeviceIDs.elements();
                            object2 = this._smaLPARIDs.elements();
                            serializable = null;
                            CIMObjectPath cIMObjectPath4 = null;
                            CIMObjectPath cIMObjectPath5 = null;
                            while (object3.hasMoreElements()) {
                                object = (String)object3.nextElement();
                                System.out.println("The stolen SMA ID is :" + (String)object);
                                cIMObjectPath4 = new CIMObjectPath("IBMHSC_SNIAdapter", string);
                                cIMObjectPath4.addKey("DeviceID", new CIMValue(object));
                                cIMObjectPath4.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                                cIMObjectPath4.addKey("SystemName", new CIMValue((Object)this._cecNameStr));
                                cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_SNIAdapter"));
                                System.out.println("The SNI object path is :" + cIMObjectPath4);
                                cIMObjectPath5 = new CIMObjectPath("IBMHSC_Partition", string);
                                short s = ((Byte)object2.nextElement()).shortValue();
                                System.out.println("The stolen partition ID is :" + s);
                                object5 = null;
                                object5 = s > 9 ? "0" + s : "00" + s;
                                object5 = (String)object5 + "*" + this._cecNameStr;
                                cIMObjectPath5.addKey("Name", new CIMValue(object5));
                                cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                                System.out.println("The partition object path is :" + cIMObjectPath5);
                                serializable = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", "root/ibmhscV3_2");
                                serializable.addKey("GroupComponent", new CIMValue((Object)cIMObjectPath5));
                                serializable.addKey("PartComponent", new CIMValue((Object)cIMObjectPath4));
                                System.out.println("The cim object path of the stolen allocSMA path is:" + serializable);
                                Trace.trace("appahscD", "Deleting SMA Allocation association = " + serializable);
                                try {
                                    System.out.println("Deleting the Allocated SMA association");
                                    CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)serializable);
                                }
                                catch (Throwable throwable) {
                                    System.out.println("Problem deleting the SNI allocation association that is freed" + serializable);
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                }
                            }
                            object = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", "root/ibmhscV3_2");
                            object6 = CimomWrapper.referenceNames((CIMOMHandle)this._cimomHandle, object, this._partitionOP, null).elements();
                            while (object6.hasMoreElements()) {
                                object5 = (CIMObjectPath)object6.nextElement();
                                System.out.println("The Allocated SNI Adapter Object Path is :" + object5);
                                System.out.println("Deleting the Allocated SNI association");
                                Trace.trace("appahscD", "Deleting SMA Allocation association = " + object5);
                                try {
                                    CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)object5);
                                }
                                catch (Throwable throwable) {
                                    System.out.println("Problem deleting the SNI allocation association" + object5);
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                }
                            }
                            System.out.println("Creating the SNI association bet partition and the SNI adapter");
                            object5 = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", string);
                            object4 = null;
                            try {
                                object4 = this._cimomHandle.getClass((CIMObjectPath)object5, false);
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                System.out.println("LOG: problem to get allocatedSNI class");
                            }
                            vector = null;
                            cIMObjectPath2 = null;
                            Object var14_46 = null;
                            cIMObjectPath = this._smaDeviceIDs.elements();
                            Enumeration enumeration = this._smaWindowSizes.elements();
                            Integer n = null;
                            if (object4 != null) {
                                while (cIMObjectPath.hasMoreElements()) {
                                    String string2 = (String)cIMObjectPath.nextElement();
                                    System.out.println("The String SNI ID is :" + string2);
                                    vector = new CIMObjectPath("IBMHSC_SNIAdapter", string);
                                    vector.addKey("DeviceID", new CIMValue((Object)string2));
                                    vector.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                                    vector.addKey("SystemName", new CIMValue((Object)this._cecNameStr));
                                    vector.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_SNIAdapter"));
                                    System.out.println("The SNI object path is :" + vector);
                                    cIMObjectPath2 = object4.newInstance();
                                    cIMObjectPath2.setProperty("GroupComponent", new CIMValue((Object)this._partitionOP));
                                    cIMObjectPath2.setProperty("PartComponent", new CIMValue((Object)vector));
                                    System.out.println("Setting the key properties followed by the window size");
                                    n = (Integer)enumeration.nextElement();
                                    System.out.println("The window size is :" + n.shortValue());
                                    cIMObjectPath2.setProperty("NumOfWindows", new CIMValue((Object)new UnsignedInt16((int)n.shortValue())));
                                    try {
                                        System.out.println("Creating the SNI Allocated Association");
                                        CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", string);
                                        cIMObjectPath6.setKeys(cIMObjectPath2.getKeyValuePairs());
                                        CimomWrapper.createInstance((CIMOMHandle)this._cimomHandle, cIMObjectPath6, (CIMInstance)cIMObjectPath2);
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                        System.out.println("LOG: problem to create the allocated SNI association");
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            System.out.println("LOG: problem creating the activate SNI assoc");
                            throwable.printStackTrace();
                        }
                    }
                    object3 = new Vector();
                    try {
                        object3 = CimomWrapper.referenceNames((CIMOMHandle)this._cimomHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2"), this._partitionOP, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        if (GlobalConfig.debugLevel((int)2) <= 0) break block110;
                        System.out.println("LOG: problem creating the activate assoc");
                    }
                }
                if (object3 != null && !((Vector)object3).isEmpty()) {
                    object2 = ((Vector)object3).elements();
                    while (object2.hasMoreElements()) {
                        serializable = (CIMObjectPath)object2.nextElement();
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("activatedLpaProf= " + serializable);
                        }
                        try {
                            CimomWrapper.deleteInstance((CIMOMHandle)this._cimomHandle, (CIMObjectPath)serializable);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            if (GlobalConfig.debugLevel((int)2) <= 0) continue;
                            System.out.println("LOG: problem delete activate");
                        }
                    }
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("done delete activatedLparProf");
                }
                object2 = null;
                try {
                    object2 = this._cimomHandle.getClass(new CIMObjectPath("IBMHSC_ActivatedLparProfile", string), false);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (GlobalConfig.debugLevel((int)2) <= 0) break block111;
                    System.out.println("LOG: problem get class of activate");
                }
            }
            if (object2 != null) {
                CIMInstance cIMInstance;
                block112: {
                    serializable = object2.newInstance();
                    serializable.setProperty("Element", new CIMValue((Object)this._partitionOP));
                    cIMInstance = null;
                    try {
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this._cimomHandle, this._partitionOP, this._cimomHandle.getClass(this._partitionOP, false), false);
                        Trace.trace("appahscD", "partitionInst = " + cIMInstance);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                        if (GlobalConfig.debugLevel((int)2) <= 0) break block112;
                        System.out.println("LOG: problem getting the lpar");
                    }
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("partitionInst = " + cIMInstance);
                }
                CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_LparProfile", string);
                cIMObjectPath.addKey("PartitionCreationClassName", cIMInstance.getProperty("CreationClassName").getValue());
                cIMObjectPath.addKey("PartitionName", cIMInstance.getProperty("Name").getValue());
                cIMObjectPath.addKey("SettingID", new CIMValue((Object)this._profileTimeStamp));
                serializable.setProperty("Setting", new CIMValue((Object)cIMObjectPath));
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("lparProfile = " + cIMObjectPath);
                    System.out.println("activatedLparProfInst = " + serializable);
                }
                object = new CIMObjectPath("IBMHSC_ActivatedLparProfile", string);
                object.setKeys(serializable.getKeyValuePairs());
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("activatedProfPath = " + object);
                }
                try {
                    CimomWrapper.createInstance((CIMOMHandle)this._cimomHandle, object, (CIMInstance)serializable);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (GlobalConfig.debugLevel((int)2) <= 0) break block113;
                    System.out.println("LOG: problem getting the activate");
                }
            }
        }
        Trace.trace("appahscT", "<- updateCIMOMCache");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("End of updateCIMOMCache");
            System.out.print("********************");
            System.out.println("********************");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildLPARStateTable() throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In buildLPARStateTable");
        }
        Trace.trace("appahscT", "-> buildLPARStateTable");
        try {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_ALL_LPARS_STATE", null, this._socket, this._cspVersion);
            Vector vector = (Vector)hashtable.get("ALL_LPAR_STATE");
            Trace.trace("appahscF", "_lparOpState = " + vector);
            int n = vector.size();
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("statVec.size = " + n);
            }
            this._lparOpState = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                this._lparOpState[n2] = ((Integer)vector.get(n2)).byteValue();
                ++n2;
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("before get lpar definition state");
            }
            this._lparDefState = new byte[n];
            int n3 = 1;
            while (n3 <= n) {
                String[] stringArray = new String[]{Integer.toHexString(n3)};
                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, this._socket, this._cspVersion);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("after get response");
                }
                this._lparDefState[n3 - 1] = ((Integer)hashtable.get("DEFINITION_STATE")).byteValue();
                Trace.trace("appahscF", "defState[" + String.valueOf(n3) + "] = " + String.valueOf(this._lparDefState[n3 - 1]));
                ++n3;
            }
        }
        finally {
            Trace.trace("appahscT", "<- buildLPARStateTable");
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("End of buildLPARStateTable");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    public Hashtable getFreeMemory(long l, long l2, int n) throws CIMException {
        System.out.println("In getFreeMemory!");
        try {
            if (this._lparDefState == null) {
                this.buildLPARStateTable();
            }
            Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
            int n2 = this._lparDefState.length;
            Vector<long[]> vector = new Vector<long[]>(0);
            long l3 = l;
            long[] lArray = null;
            int n3 = 0;
            int n4 = 1;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            Hashtable hashtable2 = null;
            long l9 = 0L;
            System.out.println("Free mem: " + l3);
            int n5 = 0;
            while (n5 < n2) {
                hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(n5 + 1)}, this._socket, this._cspVersion);
                l8 = (Long)hashtable2.get("PAGE_TABLE_ALLOC_MEMORY");
                l6 = (Long)hashtable2.get("TOT_ALLOC_MEMORY");
                l9 = (Long)hashtable2.get("TOT_MEMORY_REQUESTED");
                if (this._cspMappedVer >= 3000) {
                    l7 = (Long)hashtable2.get("POSSIBLE_MEMORY");
                }
                Trace.trace("appahscF", "reservedMem" + String.valueOf(l9));
                System.out.println("requested mem: " + l9);
                System.out.println("page table mem: " + l8);
                System.out.println("Checking if partition is valid...");
                if (this._lparDefState[n5] == 10 && n5 != this._theLPAR - 1 && (this._lparOpState[n5] == 1 || this._lparOpState[n5] == 12)) {
                    System.out.println("VALID PARTITION FOUND!");
                    lArray = new long[2];
                    lArray[n3] = n5 + 1;
                    if (this._cspMappedVer >= 3000) {
                        l5 = this.pageTableSize(l7, l2, n);
                        lArray[n4] = l9 + l5;
                    } else {
                        lArray[n4] = l9 + l8;
                    }
                    System.out.println("lparMemPair[" + n4 + "] = " + lArray[n4]);
                    System.out.println("Free mem after subtracting valid partition's memory: " + (l3 -= lArray[n4]));
                    vector.add(lArray);
                    System.out.println("valid, so add to lparMemPairList: " + vector);
                } else if (this._lparOpState[n5] == 8 || this._lparOpState[n5] == 5 || this._lparOpState[n5] == 9) {
                    System.out.println("allocated mem: " + l6);
                    long l10 = l9 - (l6 -= l8);
                    System.out.println("memDiff: " + l10);
                    if (l10 > 0L) {
                        System.out.println("lost memory: " + (l4 += l10));
                        System.out.println("Free mem after subtracting recoverable memory: " + (l3 -= l10));
                    }
                }
                ++n5;
            }
            System.out.println("After all checks, freeMem: " + l3);
            Long l11 = new Long(l3);
            Long l12 = new Long(l4);
            hashtable.put("freeMem", l11);
            hashtable.put("recovMem", l12);
            hashtable.put("stealList", vector);
            return hashtable;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new HSCCIMException(throwable);
        }
    }

    private long _sortAndSteal(long l, long l2, long l3, Vector vector) {
        Collections.sort(vector, new MemoryComparator());
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        int n4 = 1;
        long l4 = l;
        long l5 = 0L;
        long l6 = 0L;
        System.out.println("Size of lparMemPairList: " + vector.size());
        while (n2 != 0) {
            n = 0;
            while (n < n2) {
                l5 = l4 + ((long[])vector.get(n))[n4];
                Trace.trace("appahscF", "tempMemAdder = " + String.valueOf(l5));
                if (l5 >= l3) {
                    this._invalidLPARs.add(new Byte((byte)((long[])vector.get(n))[n3]));
                    System.out.println("_invalidLPARs: " + this._invalidLPARs);
                    this._memoryAssigned = l2;
                    return -1L;
                }
                ++n;
            }
            l4 = l5;
            Trace.trace("appahscF", "accumulatedMem = " + String.valueOf(l4));
            this._invalidLPARs.add(new Byte((byte)((long[])vector.get(--n))[n3]));
            System.out.println("_invalidLPARs: " + this._invalidLPARs);
            vector.removeElementAt(n);
            n2 = vector.size();
        }
        System.out.println("Activator._sortAndSteal: accumulatedMem=" + l4);
        return l4;
    }

    private void _setIndexByVersion(int n) {
        if (n < 3000) {
            this._versionLparProfId = 0;
            this._versionLparProfUsrDefName = 1;
            this._versionLparProfDraInfo = (short)8;
            this._versionLparProfSlotInfo = (short)9;
            this._versionLparProfReqDes = (short)10;
            this._versionLparProfReqCpu = (short)5;
            this._versionLparProfDesCpu = (short)4;
            this._versionLparProfReqMem = (short)7;
            this._versionLparProfDesMem = (short)6;
            this._versionLparProfSerAuth = (short)3;
            this._versionLparProfbooMod = (short)2;
            return;
        }
        if (n >= 3000) {
            this._versionLparProfId = 0;
            this._versionLparProfUsrDefName = 1;
            this._versionLparProfDraInfo = (short)12;
            this._versionLparProfSlotInfo = (short)13;
            this._versionLparProfReqDes = (short)14;
            this._versionLparProfReqCpu = (short)7;
            this._versionLparProfDesCpu = (short)6;
            this._versionLparProfMaxCpu = (short)8;
            this._versionLparProfReqMem = (short)10;
            this._versionLparProfDesMem = (short)9;
            this._versionLparProfMaxMem = (short)11;
            this._versionLparProfSerAuth = (short)3;
            this._versionLparProfbooMod = (short)2;
            this._versionLparProfRMOSize = (short)4;
            this._versionLparProfSFPSur = (short)5;
            if (n >= 4000) {
                this._versionLparProfSMAMode = (short)15;
                this._versionLparProfSMADevID = (short)16;
                this._versionLparProfSMAWindows = (short)17;
            }
            return;
        }
    }
}

